/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.wavelet.lift.LiftingSchemeBaseWavelet;
import be.tarsos.dsp.wavelet.lift.PolynomialInterpolation;

public class PolynomialWavelets
extends LiftingSchemeBaseWavelet {
    static final int numPts = 4;
    private PolynomialInterpolation fourPt = new PolynomialInterpolation();

    private void fill(float[] vec, float[] d, int N, int start) {
        int n = 4;
        if (n > N) {
            n = N;
        }
        int end = start + n;
        int j = 0;
        for (int i = start; i < end; ++i) {
            d[j] = vec[i];
            ++j;
        }
    }

    @Override
    protected void update(float[] vec, int N, int direction) {
        int half = N >> 1;
        for (int i = 0; i < half; ++i) {
            int j = i + half;
            if (direction == 1) {
                vec[i] = (vec[i] + vec[j]) / 2.0f;
                continue;
            }
            if (direction == 2) {
                vec[i] = 2.0f * vec[i] - vec[j];
                continue;
            }
            System.out.println("update: bad direction value");
        }
    }

    @Override
    protected void predict(float[] vec, int N, int direction) {
        int half = N >> 1;
        float[] d = new float[4];
        for (int i = 0; i < half; ++i) {
            float predictVal;
            if (i == 0) {
                if (half == 1) {
                    predictVal = vec[0];
                } else {
                    this.fill(vec, d, N, 0);
                    predictVal = this.fourPt.interpPoint(0.5f, half, d);
                }
            } else if (i == 1) {
                predictVal = this.fourPt.interpPoint(1.5f, half, d);
            } else if (i == half - 2) {
                predictVal = this.fourPt.interpPoint(2.5f, half, d);
            } else if (i == half - 1) {
                predictVal = this.fourPt.interpPoint(3.5f, half, d);
            } else {
                this.fill(vec, d, N, i - 1);
                predictVal = this.fourPt.interpPoint(1.5f, half, d);
            }
            int j = i + half;
            if (direction == 1) {
                vec[j] = vec[j] - predictVal;
                continue;
            }
            if (direction == 2) {
                vec[j] = vec[j] + predictVal;
                continue;
            }
            System.out.println("PolynomialWavelets::predict: bad direction value");
        }
    }

    @Override
    public void forwardTrans(float[] vec) {
        int N;
        for (int n = N = vec.length; n > 1; n >>= 1) {
            this.split(vec, n);
            this.update(vec, n, 1);
            this.predict(vec, n, 1);
        }
    }

    @Override
    public void inverseTrans(float[] vec) {
        int N = vec.length;
        for (int n = 2; n <= N; n <<= 1) {
            this.predict(vec, n, 2);
            this.update(vec, n, 2);
            this.merge(vec, n);
        }
    }
}

