/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.wavelet.lift.LiftingSchemeBaseWavelet;

public class HaarWavelet
extends LiftingSchemeBaseWavelet {
    @Override
    protected void predict(float[] vec, int N, int direction) {
        int half = N >> 1;
        for (int i = 0; i < half; ++i) {
            float predictVal = vec[i];
            int j = i + half;
            if (direction == 1) {
                vec[j] = vec[j] - predictVal;
                continue;
            }
            if (direction == 2) {
                vec[j] = vec[j] + predictVal;
                continue;
            }
            System.out.println("HaarWavelet::predict: bad direction value");
        }
    }

    public void forwardTransOne(float[] vec) {
        int N = vec.length;
        this.split(vec, N);
        this.predict(vec, N, 1);
        this.update(vec, N, 1);
    }

    @Override
    protected void update(float[] vec, int N, int direction) {
        int half = N >> 1;
        for (int i = 0; i < half; ++i) {
            int j = i + half;
            float updateVal = vec[j] / 2.0f;
            if (direction == 1) {
                vec[i] = vec[i] + updateVal;
                continue;
            }
            if (direction == 2) {
                vec[i] = vec[i] - updateVal;
                continue;
            }
            System.out.println("update: bad direction value");
        }
    }
}

