/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet;

public class HaarWaveletTransform {
    private final boolean preserveEnergy;
    private final float sqrtTwo = (float)Math.sqrt(2.0);

    public HaarWaveletTransform(boolean preserveEnergy) {
        this.preserveEnergy = preserveEnergy;
    }

    public HaarWaveletTransform() {
        this(false);
    }

    public void transform(float[] s) {
        int m = s.length;
        assert (HaarWaveletTransform.isPowerOfTwo(m));
        int n = HaarWaveletTransform.log2(m);
        int j = 2;
        int i = 1;
        for (int l = 0; l < n; ++l) {
            m /= 2;
            for (int k = 0; k < m; ++k) {
                float a = (s[j * k] + s[j * k + i]) / 2.0f;
                float c = (s[j * k] - s[j * k + i]) / 2.0f;
                if (this.preserveEnergy) {
                    a /= this.sqrtTwo;
                    c /= this.sqrtTwo;
                }
                s[j * k] = a;
                s[j * k + i] = c;
            }
            i = j;
            j *= 2;
        }
    }

    public void inverseTransform(float[] data) {
        int m = data.length;
        assert (HaarWaveletTransform.isPowerOfTwo(m));
        int n = HaarWaveletTransform.log2(m);
        int i = HaarWaveletTransform.pow2(n - 1);
        int j = 2 * i;
        m = 1;
        for (int l = n; l >= 1; --l) {
            for (int k = 0; k < m; ++k) {
                float a = data[j * k] + data[j * k + i];
                float a1 = data[j * k] - data[j * k + i];
                if (this.preserveEnergy) {
                    a *= this.sqrtTwo;
                    a1 *= this.sqrtTwo;
                }
                data[j * k] = a;
                data[j * k + i] = a1;
            }
            j = i;
            i /= 2;
            m = 2 * m;
        }
    }

    public static boolean isPowerOfTwo(int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("number: " + number);
        }
        return (number & -number) == number;
    }

    public static int log2(int bits) {
        if (bits == 0) {
            return 0;
        }
        return 31 - Integer.numberOfLeadingZeros(bits);
    }

    public static int pow2(int power) {
        return 1 << power;
    }
}

