/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util.fft;

import be.tarsos.dsp.util.fft.FloatFFT;
import be.tarsos.dsp.util.fft.WindowFunction;

public class FFT {
    private final FloatFFT fft;
    private final WindowFunction windowFunction;
    private final int fftSize;
    private final float[] window;

    public FFT(int size) {
        this(size, null);
    }

    public FFT(int size, WindowFunction windowFunction) {
        this.fft = new FloatFFT(size);
        this.fftSize = size;
        this.windowFunction = windowFunction;
        this.window = (float[])(windowFunction == null ? null : windowFunction.generateCurve(size));
    }

    public void forwardTransform(float[] data) {
        if (this.windowFunction != null) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = data[i] * this.window[i];
            }
        }
        this.fft.realForward(data);
    }

    public void complexForwardTransform(float[] data) {
        if (this.windowFunction != null) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = data[i] * this.window[i];
            }
        }
        this.fft.complexForward(data);
    }

    public void backwardsTransform(float[] data) {
        this.fft.realInverse(data, true);
    }

    public double binToHz(int binIndex, float sampleRate) {
        return (double)((float)binIndex * sampleRate) / (double)this.fftSize;
    }

    public int size() {
        return this.fftSize;
    }

    public float modulus(float[] data, int index) {
        int realIndex = 2 * index;
        int imgIndex = 2 * index + 1;
        float modulus = data[realIndex] * data[realIndex] + data[imgIndex] * data[imgIndex];
        return (float)Math.sqrt(modulus);
    }

    public void modulus(float[] data, float[] amplitudes) {
        assert (data.length / 2 == amplitudes.length);
        for (int i = 0; i < amplitudes.length; ++i) {
            amplitudes[i] = this.modulus(data, i);
        }
    }

    public void powerPhaseFFT(float[] data, float[] power, float[] phase) {
        assert (data.length / 2 == power.length);
        assert (data.length / 2 == phase.length);
        if (this.windowFunction != null) {
            this.windowFunction.apply(data);
        }
        this.fft.realForward(data);
        this.powerAndPhaseFromFFT(data, power, phase);
    }

    public void powerAndPhaseFromFFT(float[] data, float[] power, float[] phase) {
        phase[0] = (float)Math.PI;
        power[0] = -data[0];
        for (int i = 1; i < power.length; ++i) {
            int realIndex = 2 * i;
            int imgIndex = 2 * i + 1;
            power[i] = (float)Math.sqrt(data[realIndex] * data[realIndex] + data[imgIndex] * data[imgIndex]);
            phase[i] = (float)Math.atan2(data[imgIndex], data[realIndex]);
        }
    }

    public void powerPhaseFFTBeatRootOnset(float[] data, float[] power, float[] phase) {
        this.powerPhaseFFT(data, power, phase);
        power[0] = (float)Math.sqrt(data[0] * data[0] + data[1] * data[1]);
    }

    public void multiply(float[] data, float[] other) {
        assert (data.length == other.length);
        if (data.length != other.length) {
            throw new IllegalArgumentException("Both arrays with imaginary numbers shouldb e of equal length");
        }
        for (int i = 1; i < data.length - 1; i += 2) {
            int realIndex = i;
            int imgIndex = i + 1;
            float tempReal = data[realIndex] * other[realIndex] + -1.0f * data[imgIndex] * other[imgIndex];
            float tempImg = data[realIndex] * other[imgIndex] + data[imgIndex] * other[realIndex];
            data[realIndex] = tempReal;
            data[imgIndex] = tempImg;
        }
    }
}

