/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

public final class PitchConverter {
    private static final double REF_FREQ = 8.17579892;
    private static final double LOG_TWO = Math.log(2.0);

    private PitchConverter() {
    }

    public static int hertzToMidiKey(Double hertzValue) {
        int midiKey = (int)Math.round(PitchConverter.hertzToMidiCent(hertzValue));
        if (midiKey < 0 || midiKey > 127) {
            // empty if block
        }
        return midiKey;
    }

    public static double midiKeyToHertz(int midiKey) {
        if (midiKey < 0 || midiKey > 127) {
            throw new IllegalArgumentException("MIDI keys are values from 0 to 127, inclusive " + midiKey + " is invalid.");
        }
        return PitchConverter.midiCentToHertz(midiKey);
    }

    public static double hertzToRelativeCent(double hertzValue) {
        double absoluteCentValue = PitchConverter.hertzToAbsoluteCent(hertzValue);
        if (absoluteCentValue < 0.0) {
            absoluteCentValue = Math.abs(1200.0 + absoluteCentValue);
        }
        return absoluteCentValue % 1200.0;
    }

    public static double hertzToAbsoluteCent(double hertzValue) {
        double pitchInAbsCent = 0.0;
        if (!(hertzValue > 0.0)) {
            throw new IllegalArgumentException("Pitch in Hz schould be greater than zero, is " + hertzValue);
        }
        pitchInAbsCent = 1200.0 * Math.log(hertzValue / 8.17579892) / LOG_TWO;
        return pitchInAbsCent;
    }

    public static double absoluteCentToHertz(double absoluteCent) {
        return 8.17579892 * Math.pow(2.0, absoluteCent / 1200.0);
    }

    public static double hertzToMidiCent(double hertzValue) {
        double pitchInMidiCent = 0.0;
        if (hertzValue != 0.0) {
            pitchInMidiCent = 12.0 * Math.log(hertzValue / 440.0) / LOG_TWO + 69.0;
        }
        return pitchInMidiCent;
    }

    public static double midiCentToHertz(double midiCent) {
        return 440.0 * Math.pow(2.0, (midiCent - 69.0) / 12.0);
    }

    public static double centToRatio(double cent) {
        double ratio = Math.pow(10.0, Math.log10(2.0) * cent / 1200.0);
        return ratio;
    }

    public static double ratioToCent(double ratio) {
        double cent = 1200.0 / Math.log10(2.0) * Math.log10(ratio);
        return cent;
    }
}

