/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.LinkedPanel;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class SelectionLayer
extends MouseAdapter
implements Layer {
    private final CoordinateSystem cs;
    private final Color color;

    public SelectionLayer(CoordinateSystem cs) {
        this(cs, Color.ORANGE);
    }

    public SelectionLayer(CoordinateSystem cs, Color color) {
        this.cs = cs;
        this.color = color;
    }

    @Override
    public void draw(Graphics2D graphics) {
        double startX = this.cs.getStartX();
        double startY = this.cs.getStartY();
        double endX = this.cs.getEndX();
        double endY = this.cs.getEndY();
        if (startX != Double.MAX_VALUE) {
            double temp;
            if (startX > endX) {
                temp = startX;
                startX = endX;
                endX = temp;
            }
            if (startY > endY) {
                temp = startY;
                startY = endY;
                endY = temp;
            }
            int x = (int)Math.round(startX);
            int y = (int)Math.round(startY);
            int width = (int)Math.round(endX) - x;
            int height = (int)Math.round(endY) - y;
            graphics.setColor(this.color);
            graphics.drawRect(x, y, width, height);
        }
    }

    @Override
    public String getName() {
        return "Selection Layer";
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            LinkedPanel panel = (LinkedPanel)e.getComponent();
            Graphics2D graphics = (Graphics2D)panel.getGraphics();
            graphics.setTransform(panel.getTransform());
            Point2D units = LayerUtilities.pixelsToUnits(graphics, e.getX(), e.getY());
            if (!panel.getCoordinateSystem().hasStartPoint()) {
                panel.getCoordinateSystem().setStartPoint(units.getX(), units.getY());
            } else {
                panel.getCoordinateSystem().setEndPoint(units.getX(), units.getY());
            }
            panel.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            LinkedPanel panel = (LinkedPanel)e.getComponent();
            panel.getViewPort().zoomToSelection();
            panel.invalidate();
        }
    }
}

