/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.TooltipLayer;
import be.tarsos.dsp.util.PitchConverter;
import be.tarsos.dsp.wavelet.HaarWaveletTransform;
import be.tarsos.dsp.wavelet.lift.Daubechies4Wavelet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Scalogram
implements Layer,
Runnable,
TooltipLayer.TooltipTextGenerator {
    private final String audioFile;
    private TreeMap<Double, ScalogramFrame> features;
    private final CoordinateSystem cs;

    public Scalogram(CoordinateSystem cs, String audioFile) {
        this.audioFile = audioFile;
        this.cs = cs;
        this.features = null;
        new Thread((Runnable)this, "Extract Scalogram").start();
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.features == null) {
            return;
        }
        SortedMap<Double, ScalogramFrame> spectralInfoSubMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
        for (Map.Entry frameEntry : spectralInfoSubMap.entrySet()) {
            double timeStart = (Double)frameEntry.getKey();
            ScalogramFrame frame = (ScalogramFrame)frameEntry.getValue();
            for (int level = 0; level < frame.dataPerScale.length; ++level) {
                for (int block = 0; block < frame.dataPerScale[level].length; ++block) {
                    Color color = Color.black;
                    float centsStartingPoint = frame.startFrequencyPerLevel[level];
                    float centsHeight = frame.stopFrequencyPerLevel[level] - centsStartingPoint;
                    if (!(centsStartingPoint + centsHeight >= this.cs.getMin(Axis.Y)) || !(centsStartingPoint <= this.cs.getMax(Axis.Y))) continue;
                    float factor = Math.abs(frame.dataPerScale[level][block] / frame.currentMax);
                    double startTimeBlock = timeStart + (double)((float)(block + 1) * frame.durationsOfBlockPerLevel[level]);
                    double timeDuration = frame.durationsOfBlockPerLevel[level];
                    int greyValue = (int)((double)factor * 0.99 * 255.0);
                    greyValue = Math.max(0, greyValue);
                    color = new Color(greyValue, greyValue, greyValue);
                    graphics.setColor(color);
                    graphics.fillRect((int)Math.round(startTimeBlock * 1000.0), Math.round(centsStartingPoint), (int)Math.round(timeDuration * 1000.0), (int)Math.ceil(centsHeight));
                }
            }
        }
    }

    @Override
    public String getName() {
        return "Scalogram";
    }

    @Override
    public void run() {
        AudioDispatcher adp = AudioDispatcherFactory.fromPipe(this.audioFile, 44100, 131072, 0);
        adp.addAudioProcessor(new AudioProcessor(){
            Daubechies4Wavelet wt = new Daubechies4Wavelet();
            TreeMap<Double, ScalogramFrame> calculatigFeatures = new TreeMap();
            ScalogramFrame prevFrame;

            @Override
            public boolean process(AudioEvent audioEvent) {
                float[] audioBuffer = (float[])audioEvent.getFloatBuffer().clone();
                this.wt.forwardTrans(audioBuffer);
                float currentMax = 0.0f;
                if (this.prevFrame != null) {
                    currentMax = this.prevFrame.currentMax * 0.99f;
                }
                ScalogramFrame currentFrame = new ScalogramFrame(audioBuffer, currentMax);
                this.calculatigFeatures.put(audioEvent.getTimeStamp(), currentFrame);
                this.prevFrame = currentFrame;
                return true;
            }

            @Override
            public void processingFinished() {
                Scalogram.this.features = this.calculatigFeatures;
            }
        });
        adp.run();
    }

    @Override
    public String generateTooltip(CoordinateSystem cs, Point2D point) {
        return "Scale info";
    }

    private static class ScalogramFrame {
        float[][] dataPerScale;
        float[] durationsOfBlockPerLevel;
        float[] startFrequencyPerLevel;
        float[] stopFrequencyPerLevel;
        float currentMax;

        public ScalogramFrame(float[] transformedData, float currentMax) {
            this.currentMax = currentMax;
            int levels = HaarWaveletTransform.log2(transformedData.length);
            this.dataPerScale = new float[levels][];
            this.durationsOfBlockPerLevel = new float[levels];
            this.startFrequencyPerLevel = new float[levels];
            this.stopFrequencyPerLevel = new float[levels];
            for (int i = 0; i < levels; ++i) {
                int samples = HaarWaveletTransform.pow2(i);
                this.dataPerScale[i] = new float[samples];
                this.durationsOfBlockPerLevel[i] = 131072.0f / (float)samples / 44100.0f;
                this.stopFrequencyPerLevel[i] = (float)PitchConverter.hertzToAbsoluteCent(44100.0f / (float)HaarWaveletTransform.pow2(levels - i));
                if (i > 0) {
                    this.startFrequencyPerLevel[i] = this.stopFrequencyPerLevel[i - 1];
                }
                this.mra(transformedData, i, this.dataPerScale);
            }
        }

        private void mra(float[] transformedData, int level, float[][] dataPerScale) {
            int startIndex = transformedData.length / HaarWaveletTransform.pow2(dataPerScale.length - level);
            int stopIndex = transformedData.length / HaarWaveletTransform.pow2(dataPerScale.length - level - 1);
            int j = 0;
            for (int i = startIndex; i < stopIndex; ++i) {
                dataPerScale[level][j] = -1.0f * transformedData[i];
                ++j;
            }
            this.normalize(dataPerScale[level]);
        }

        private void normalize(float[] data) {
            int i;
            for (i = 0; i < data.length; ++i) {
                this.currentMax = Math.max(Math.abs(data[i]), this.currentMax);
            }
            for (i = 0; i < data.length; ++i) {
            }
        }
    }
}

