/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LayerUtilities {
    private LayerUtilities() {
    }

    public static Point2D pixelsToUnits(Graphics2D g, int x, int y) {
        Point2D units = null;
        try {
            units = g.getTransform().inverseTransform(new Point2D.Double(x, y), null);
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        return units;
    }

    public static float pixelsToUnits(Graphics2D g, int pixels, boolean horizontal) {
        float numberOfUnits = 0.0f;
        try {
            Point2D.Double originSrc = new Point2D.Double(0.0, 0.0);
            Point2D originDest = g.getTransform().inverseTransform(originSrc, null);
            Point2D.Double destSrc = new Point2D.Double(pixels, pixels);
            Point2D destDest = g.getTransform().inverseTransform(destSrc, null);
            numberOfUnits = horizontal ? (float)(destDest.getX() - originDest.getX()) : (float)(-destDest.getY() + originDest.getY());
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        return numberOfUnits;
    }

    public static float unitsToPixels(Graphics2D g, float units, boolean horizontal) {
        Point2D.Float firstSource = new Point2D.Float(units, units);
        Point2D.Float firstDest = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float secondSource = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float secondDest = new Point2D.Float(0.0f, 0.0f);
        g.getTransform().transform(firstSource, firstDest);
        g.getTransform().transform(secondSource, secondDest);
        if (horizontal) {
            return (float)(((Point2D)firstDest).getX() - ((Point2D)secondDest).getX());
        }
        return (float)(((Point2D)firstDest).getY() - ((Point2D)secondDest).getY());
    }

    public static Rectangle2D drawString(Graphics2D graphics, String text, double x, double y, boolean centerHorizontal, boolean centerVertical, Color backgroundColor) {
        return LayerUtilities.drawString(graphics, text, x, y, centerHorizontal, centerVertical, backgroundColor, Color.BLACK);
    }

    public static Rectangle2D drawString(Graphics2D graphics, String text, double x, double y, boolean centerHorizontal, boolean centerVertical, Color backgroundColor, Color textColor) {
        AffineTransform transform = graphics.getTransform();
        Point2D.Double source = new Point2D.Double(x, y);
        Point2D.Double destination = new Point2D.Double();
        transform.transform(source, destination);
        try {
            transform.invert();
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        graphics.transform(transform);
        Rectangle2D r = graphics.getFontMetrics().getStringBounds(text, graphics);
        int xPosition = Math.round((float)(((Point2D)destination).getX() - (centerHorizontal ? r.getWidth() / 2.0 - 1.0 : 0.0)));
        int yPosition = Math.round((float)(((Point2D)destination).getY() + (centerVertical ? r.getHeight() / 2.0 - 1.5 : 0.0)));
        if (backgroundColor != null) {
            graphics.setColor(backgroundColor);
            int width = (int)(r.getMaxY() - r.getMinY());
            int height = (int)(r.getMaxX() - r.getMinX());
            graphics.fillRect(xPosition, yPosition - width, height, width);
        }
        Rectangle2D.Double boundingRectangle = new Rectangle2D.Double(xPosition, (double)yPosition - r.getHeight(), r.getWidth(), r.getHeight());
        transform.createTransformedShape(boundingRectangle);
        graphics.setColor(textColor);
        graphics.drawString(text, xPosition, yPosition);
        try {
            transform.invert();
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        graphics.transform(transform);
        return boundingRectangle;
    }
}

