/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.ConstantQ;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.util.PitchConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ConstantQLayer
implements Layer,
Runnable {
    private TreeMap<Double, float[]> features;
    private final CoordinateSystem cs;
    private final File audioFile;
    private float maxSpectralEnergy = 0.0f;
    private float minSpectralEnergy = 100000.0f;
    private float[] binStartingPointsInCents;
    private float binWith;
    private float binHeight;
    private int minimumFrequencyInCents = 4000;
    private int maximumFrequencyInCents = 10500;
    private int binsPerOctave = 48;
    private int increment;

    public ConstantQLayer(CoordinateSystem cs, File audioFile, int increment, int minFreqInCents, int maxFreqInCents, int binsPerOctave) {
        this.cs = cs;
        this.audioFile = audioFile;
        this.increment = increment;
        this.minimumFrequencyInCents = minFreqInCents;
        this.maximumFrequencyInCents = maxFreqInCents;
        new Thread((Runnable)this, "Constant Q Initialization").start();
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.features != null) {
            SortedMap<Double, float[]> spectralInfoSubMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
            double currentMaxSpectralEnergy = 0.0;
            for (Map.Entry column : spectralInfoSubMap.entrySet()) {
                float[] spectralEnergy = (float[])column.getValue();
                for (int i = 0; i < spectralEnergy.length; ++i) {
                    currentMaxSpectralEnergy = Math.max(currentMaxSpectralEnergy, (double)spectralEnergy[i]);
                }
            }
            for (Map.Entry column : spectralInfoSubMap.entrySet()) {
                double timeStart = (Double)column.getKey();
                float[] spectralEnergy = (float[])column.getValue();
                for (int i = 0; i < spectralEnergy.length; ++i) {
                    Color color = Color.black;
                    float centsStartingPoint = this.binStartingPointsInCents[i];
                    if (!(centsStartingPoint >= this.cs.getMin(Axis.Y)) || !(centsStartingPoint <= this.cs.getMax(Axis.Y))) continue;
                    int greyValue = 255 - (int)(Math.log1p(spectralEnergy[i]) / Math.log1p(currentMaxSpectralEnergy) * 255.0);
                    greyValue = Math.max(0, greyValue);
                    color = new Color(greyValue, greyValue, greyValue);
                    graphics.setColor(color);
                    graphics.fillRect((int)Math.round(timeStart * 1000.0), Math.round(centsStartingPoint), Math.round(this.binWith * 1000.0f), (int)Math.ceil(this.binHeight));
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            float minimumFrequencyInHertz = (float)PitchConverter.absoluteCentToHertz(this.minimumFrequencyInCents);
            float maximumFrequencyInHertz = (float)PitchConverter.absoluteCentToHertz(this.maximumFrequencyInCents);
            float sampleRate = AudioDispatcherFactory.fromFile(this.audioFile, 2048, 0).getFormat().getFrameRate();
            final ConstantQ constantQ = new ConstantQ(sampleRate, minimumFrequencyInHertz, maximumFrequencyInHertz, this.binsPerOctave);
            this.binWith = (float)this.increment / sampleRate;
            this.binHeight = 1200.0f / (float)this.binsPerOctave;
            float[] startingPointsInHertz = constantQ.getFreqencies();
            this.binStartingPointsInCents = new float[startingPointsInHertz.length];
            for (int i = 0; i < this.binStartingPointsInCents.length; ++i) {
                this.binStartingPointsInCents[i] = (float)PitchConverter.hertzToAbsoluteCent(startingPointsInHertz[i]);
            }
            int size = constantQ.getFFTlength();
            AudioDispatcher adp = AudioDispatcherFactory.fromFile(this.audioFile, size, size - this.increment);
            final double constantQLag = (double)((float)size / adp.getFormat().getSampleRate()) - (double)this.binWith / 2.0;
            final TreeMap fe = new TreeMap();
            adp.addAudioProcessor(constantQ);
            adp.addAudioProcessor(new AudioProcessor(){

                @Override
                public void processingFinished() {
                    float minValue = 5.0E-6f;
                    for (float[] magnitudes : fe.values()) {
                        for (int i = 0; i < magnitudes.length; ++i) {
                            magnitudes[i] = Math.max(minValue, magnitudes[i]);
                            magnitudes[i] = (float)Math.log1p(magnitudes[i]);
                            ConstantQLayer.this.maxSpectralEnergy = Math.max(magnitudes[i], ConstantQLayer.this.maxSpectralEnergy);
                            ConstantQLayer.this.minSpectralEnergy = Math.min(magnitudes[i], ConstantQLayer.this.minSpectralEnergy);
                        }
                    }
                    ConstantQLayer.this.minSpectralEnergy = Math.abs(ConstantQLayer.this.minSpectralEnergy);
                    ConstantQLayer.this.features = fe;
                }

                @Override
                public boolean process(AudioEvent audioEvent) {
                    fe.put(audioEvent.getTimeStamp() - constantQLag, (float[])constantQ.getMagnitudes().clone());
                    return true;
                }
            });
            new Thread((Runnable)adp, "Constant Q Calculation").start();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Constant-Q Layer";
    }
}

