/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.ViewPort;
import be.tarsos.dsp.ui.layers.Layer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class LinkedPanel
extends JPanel {
    private static final long serialVersionUID = -5055686566048886896L;
    private List<Layer> layers;
    private final ViewPort viewPort;
    private CoordinateSystem cs;

    public LinkedPanel(CoordinateSystem coordinateSystem) {
        this.setFocusable(true);
        this.layers = new ArrayList<Layer>();
        this.cs = coordinateSystem;
        this.viewPort = new ViewPort(this.cs);
        this.setVisible(true);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkedPanel.this.transferFocusBackward();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkedPanel.this.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }

    public void addLayer(Layer l) {
        this.layers.add(l);
        if (l instanceof MouseMotionListener) {
            this.addMouseMotionListener((MouseMotionListener)((Object)l));
        }
        if (l instanceof MouseListener) {
            this.addMouseListener((MouseListener)((Object)l));
        }
        if (l instanceof MouseWheelListener) {
            this.addMouseWheelListener((MouseWheelListener)((Object)l));
        }
        if (l instanceof KeyListener) {
            this.addKeyListener((KeyListener)((Object)l));
        }
    }

    public AffineTransform getTransform() {
        double xDelta = this.cs.getDelta(Axis.X);
        double yDelta = this.cs.getDelta(Axis.Y);
        AffineTransform transform = new AffineTransform();
        transform.translate(0.0, this.getHeight());
        transform.scale((double)this.getWidth() / xDelta, (double)(-this.getHeight()) / yDelta);
        transform.translate(-this.cs.getMin(Axis.X), -this.cs.getMin(Axis.Y));
        return transform;
    }

    public AffineTransform updateTransform(AffineTransform transform) {
        double xDelta = this.cs.getDelta(Axis.X);
        double yDelta = this.cs.getDelta(Axis.Y);
        transform.translate(0.0, this.getHeight());
        transform.scale((double)this.getWidth() / xDelta, (double)(-this.getHeight()) / yDelta);
        transform.translate(-this.cs.getMin(Axis.X), -this.cs.getMin(Axis.Y));
        return transform;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setTransform(this.updateTransform(graphics.getTransform()));
        if (!this.layers.isEmpty()) {
            for (Layer layer : this.layers) {
                layer.draw(graphics);
            }
        }
    }

    public void removeLayer(Layer layer) {
        this.layers.remove(layer);
        if (layer instanceof MouseMotionListener) {
            this.removeMouseMotionListener((MouseMotionListener)((Object)layer));
        }
        if (layer instanceof MouseListener) {
            this.removeMouseListener((MouseListener)((Object)layer));
        }
        if (layer instanceof MouseWheelListener) {
            this.removeMouseWheelListener((MouseWheelListener)((Object)layer));
        }
        if (layer instanceof KeyListener) {
            this.removeKeyListener((KeyListener)((Object)layer));
        }
    }

    public void removeLayers() {
        while (this.layers.size() > 0) {
            this.removeLayer(this.layers.get(0));
        }
    }
}

