/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.LinkedPanel;
import be.tarsos.dsp.ui.ViewPort;
import be.tarsos.dsp.ui.layers.AmplitudeAxisLayer;
import be.tarsos.dsp.ui.layers.BackgroundLayer;
import be.tarsos.dsp.ui.layers.BeatLayer;
import be.tarsos.dsp.ui.layers.ConstantQLayer;
import be.tarsos.dsp.ui.layers.DragMouseListenerLayer;
import be.tarsos.dsp.ui.layers.LegendLayer;
import be.tarsos.dsp.ui.layers.PitchContourLayer;
import be.tarsos.dsp.ui.layers.SelectionLayer;
import be.tarsos.dsp.ui.layers.TimeAxisLayer;
import be.tarsos.dsp.ui.layers.VerticalFrequencyAxisLayer;
import be.tarsos.dsp.ui.layers.WaveFormLayer;
import be.tarsos.dsp.ui.layers.ZoomMouseListenerLayer;
import be.tarsos.dsp.ui.layers.pch.PitchClassHistogramLayer;
import be.tarsos.dsp.ui.layers.pch.ScaleLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class LinkedFrame
extends JFrame
implements ViewPort.ViewPortChangedListener {
    private JSplitPane lastSplitPane;
    private static final long serialVersionUID = 7301610309790983406L;
    private static LinkedFrame instance;
    private static HashMap<String, LinkedPanel> panels;
    private boolean drawing = false;

    public static void main(String ... strings) {
        LinkedFrame.getInstance();
    }

    protected JSplitPane getLastSplitPane() {
        return this.lastSplitPane;
    }

    private LinkedFrame() {
        panels = new HashMap();
    }

    public static LinkedFrame getInstance() {
        if (instance == null) {
            instance = new LinkedFrame();
            instance.initialise();
        }
        return instance;
    }

    public void initialise() {
        JSplitPane contentPane;
        this.setMinimumSize(new Dimension(800, 400));
        this.lastSplitPane = contentPane = new JSplitPane(0);
        this.setContentPane(contentPane);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.pack();
        contentPane.setDividerLocation(0);
        this.buildStdSetUp();
        this.setVisible(true);
    }

    public void createNewSplitPane() {
        this.lastSplitPane.setDividerSize(2);
        JSplitPane sp = new JSplitPane(0);
        sp.setDividerSize(0);
        this.lastSplitPane.add((Component)sp, "bottom");
        this.lastSplitPane = sp;
    }

    @Override
    public void viewPortChanged(ViewPort newViewPort) {
        if (!this.drawing) {
            this.drawing = true;
            for (LinkedPanel panel : panels.values()) {
                panel.repaint();
            }
            this.drawing = false;
        }
    }

    private CoordinateSystem getCoordinateSystem(AxisUnit yUnits) {
        float minValue = -1000.0f;
        float maxValue = 1000.0f;
        if (yUnits == AxisUnit.FREQUENCY) {
            minValue = 200.0f;
            maxValue = 8000.0f;
        }
        return new CoordinateSystem(yUnits, minValue, maxValue);
    }

    private void buildStdSetUp() {
        CoordinateSystem cs = this.getCoordinateSystem(AxisUnit.AMPLITUDE);
        File audioFile = new File("/home/joren/Desktop/08._Ladrang_Kandamanyura_10s-20s.wav");
        LinkedPanel panel = new LinkedPanel(cs);
        panel.addLayer(new ZoomMouseListenerLayer());
        panel.addLayer(new DragMouseListenerLayer(cs));
        panel.addLayer(new BackgroundLayer(cs));
        panel.addLayer(new AmplitudeAxisLayer(cs));
        panel.addLayer(new TimeAxisLayer(cs));
        panel.addLayer(new WaveFormLayer(cs, audioFile));
        panel.addLayer(new BeatLayer(cs, audioFile, true, true));
        panel.addLayer(new SelectionLayer(cs));
        LegendLayer legend = new LegendLayer(cs, 50);
        panel.addLayer(legend);
        legend.addEntry("Onsets", Color.BLUE);
        legend.addEntry("Beats", Color.RED);
        panel.getViewPort().addViewPortChangedListener(this);
        panels.put("Waveform", panel);
        this.lastSplitPane.add((Component)panel, "top");
        cs = this.getCoordinateSystem(AxisUnit.FREQUENCY);
        panel = new LinkedPanel(cs);
        panel.addLayer(new ZoomMouseListenerLayer());
        panel.addLayer(new DragMouseListenerLayer(cs));
        panel.addLayer(new BackgroundLayer(cs));
        panel.addLayer(new ConstantQLayer(cs, audioFile, 2048, 3600, 10800, 12));
        panel.addLayer(new PitchContourLayer(cs, audioFile, Color.red, 2048, 1024));
        panel.addLayer(new SelectionLayer(cs));
        panel.addLayer(new VerticalFrequencyAxisLayer(cs));
        panel.addLayer(new TimeAxisLayer(cs));
        panel.getViewPort().addViewPortChangedListener(this);
        CoordinateSystem pchCS = new CoordinateSystem(AxisUnit.OCCURENCES, 0.0f, 1000.0f, true);
        pchCS.setMin(Axis.X, 0.0f);
        pchCS.setMax(Axis.X, 1200.0f);
        final LinkedPanel pchPanel = new LinkedPanel(pchCS);
        pchPanel.addLayer(new BackgroundLayer(pchCS));
        pchPanel.addLayer(new DragMouseListenerLayer(pchCS));
        pchPanel.addLayer(new PitchClassHistogramLayer());
        pchPanel.addLayer(new ScaleLayer(pchCS, true));
        pchPanel.addLayer(new ScaleLayer(pchCS, false));
        pchPanel.getViewPort().addViewPortChangedListener(new ViewPort.ViewPortChangedListener(){
            boolean painting = false;

            @Override
            public void viewPortChanged(ViewPort newViewPort) {
                if (!this.painting) {
                    this.painting = true;
                    pchPanel.repaint();
                    this.painting = false;
                }
            }
        });
        this.lastSplitPane.add((Component)pchPanel, "bottom");
        panels.put("Spectral info", panel);
        this.lastSplitPane.setDividerLocation(0.7);
    }
}

