/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;

public class CoordinateSystem {
    private final AxisUnit xAxisUnits;
    private final AxisUnit yAxisUnits;
    private float xMin = 0.0f;
    private float xMax = 10000.0f;
    private float yMin;
    private float yMax;
    private final boolean wraps;
    private float wrappingOrigin;
    private double startX = Double.MAX_VALUE;
    private double startY = Double.MAX_VALUE;
    private double endX = Double.MAX_VALUE;
    private double endY = Double.MAX_VALUE;

    public CoordinateSystem(AxisUnit yAxisUnits, float yMin, float yMax) {
        this(AxisUnit.TIME, yAxisUnits, yMin, yMax, false);
    }

    public CoordinateSystem(AxisUnit yAxisUnits, float yMin, float yMax, boolean wraps) {
        this(AxisUnit.TIME, yAxisUnits, yMin, yMax, wraps);
    }

    public CoordinateSystem(AxisUnit xAxisUnits, AxisUnit yAxisUnits, float yMin, float yMax, boolean wraps) {
        this.yAxisUnits = yAxisUnits;
        this.xAxisUnits = xAxisUnits;
        this.yMin = yMin;
        this.yMax = yMax;
        this.wraps = wraps;
        this.wrappingOrigin = 0.0f;
    }

    public float getWrappingOrigin() {
        return this.wrappingOrigin;
    }

    public void setWrappingOrigin(float wrappingOrigin) {
        this.wrappingOrigin = wrappingOrigin;
    }

    public float getRealXValue(float value) {
        float realValue = this.isWrapping() ? (1000.0f * this.getDelta(Axis.X) + value + this.getWrappingOrigin()) % this.getDelta(Axis.X) : value;
        return realValue;
    }

    public float getDelta(Axis axis) {
        float delta = axis == Axis.X ? this.xMax - this.xMin : this.yMax - this.yMin;
        return delta;
    }

    public AxisUnit getUnitsForAxis(Axis axis) {
        AxisUnit unit = axis == Axis.X ? this.xAxisUnits : this.yAxisUnits;
        return unit;
    }

    public float getMin(Axis axis) {
        float min = axis == Axis.X ? this.xMin : this.yMin;
        return min;
    }

    public float getMax(Axis axis) {
        float max = axis == Axis.X ? this.xMax : this.yMax;
        return max;
    }

    public void setMax(Axis axis, float value) {
        if (axis == Axis.X) {
            this.xMax = value;
        } else {
            this.yMax = value;
        }
    }

    public void setMin(Axis axis, float value) {
        if (axis == Axis.X) {
            this.xMin = value;
        } else {
            this.yMin = value;
        }
    }

    public void setStartPoint(double x, double y) {
        this.startX = x;
        this.startY = y;
    }

    public boolean hasStartPoint() {
        return this.startX != Double.MAX_VALUE;
    }

    public void setEndPoint(double x, double y) {
        this.endX = x;
        this.endY = y;
    }

    public void clearPoints() {
        this.startX = Double.MAX_VALUE;
        this.startY = Double.MAX_VALUE;
        this.endX = Double.MAX_VALUE;
        this.endY = Double.MAX_VALUE;
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getEndY() {
        return this.endY;
    }

    public double getEndX() {
        return this.endX;
    }

    public boolean isWrapping() {
        return this.wraps;
    }
}

