/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.synthesis;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class SineGenerator
implements AudioProcessor {
    private double gain;
    private double frequency;
    private double phase;

    public SineGenerator() {
        this(1.0, 440.0);
    }

    public SineGenerator(double gain, double frequency) {
        this.gain = gain;
        this.frequency = frequency;
        this.phase = 0.0;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] buffer = audioEvent.getFloatBuffer();
        double sampleRate = audioEvent.getSampleRate();
        double twoPiF = Math.PI * 2 * this.frequency;
        double time = 0.0;
        int i = 0;
        while (i < buffer.length) {
            time = (double)i / sampleRate;
            int n = i++;
            buffer[n] = buffer[n] + (float)(this.gain * Math.sin(twoPiF * time + this.phase));
        }
        this.phase = twoPiF * (double)buffer.length / sampleRate + this.phase;
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

