/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;
import java.util.ArrayList;
import java.util.List;

public final class McLeodPitchMethod
implements PitchDetector {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int DEFAULT_OVERLAP = 768;
    private static final double DEFAULT_CUTOFF = 0.97;
    private static final double SMALL_CUTOFF = 0.5;
    private static final double LOWER_PITCH_CUTOFF = 80.0;
    private final double cutoff;
    private final float sampleRate;
    private final float[] nsdf;
    private float turningPointX;
    private float turningPointY;
    private final List<Integer> maxPositions = new ArrayList<Integer>();
    private final List<Float> periodEstimates = new ArrayList<Float>();
    private final List<Float> ampEstimates = new ArrayList<Float>();
    private final PitchDetectionResult result;

    public McLeodPitchMethod(float audioSampleRate) {
        this(audioSampleRate, 1024, 0.97);
    }

    public McLeodPitchMethod(float audioSampleRate, int audioBufferSize) {
        this(audioSampleRate, audioBufferSize, 0.97);
    }

    public McLeodPitchMethod(float audioSampleRate, int audioBufferSize, double cutoffMPM) {
        this.sampleRate = audioSampleRate;
        this.nsdf = new float[audioBufferSize];
        this.cutoff = cutoffMPM;
        this.result = new PitchDetectionResult();
    }

    private void normalizedSquareDifference(float[] audioBuffer) {
        for (int tau = 0; tau < audioBuffer.length; ++tau) {
            float acf = 0.0f;
            float divisorM = 0.0f;
            for (int i = 0; i < audioBuffer.length - tau; ++i) {
                acf += audioBuffer[i] * audioBuffer[i + tau];
                divisorM += audioBuffer[i] * audioBuffer[i] + audioBuffer[i + tau] * audioBuffer[i + tau];
            }
            this.nsdf[tau] = 2.0f * acf / divisorM;
        }
    }

    @Override
    public PitchDetectionResult getPitch(float[] audioBuffer) {
        float pitch;
        this.maxPositions.clear();
        this.periodEstimates.clear();
        this.ampEstimates.clear();
        this.normalizedSquareDifference(audioBuffer);
        this.peakPicking();
        double highestAmplitude = Double.NEGATIVE_INFINITY;
        for (Integer tau : this.maxPositions) {
            highestAmplitude = Math.max(highestAmplitude, (double)this.nsdf[tau]);
            if (!((double)this.nsdf[tau] > 0.5)) continue;
            this.parabolicInterpolation(tau);
            this.ampEstimates.add(Float.valueOf(this.turningPointY));
            this.periodEstimates.add(Float.valueOf(this.turningPointX));
            highestAmplitude = Math.max(highestAmplitude, (double)this.turningPointY);
        }
        if (this.periodEstimates.isEmpty()) {
            pitch = -1.0f;
        } else {
            double period;
            float pitchEstimate;
            double actualCutoff = this.cutoff * highestAmplitude;
            int periodIndex = 0;
            for (int i = 0; i < this.ampEstimates.size(); ++i) {
                if (!((double)this.ampEstimates.get(i).floatValue() >= actualCutoff)) continue;
                periodIndex = i;
                break;
            }
            pitch = (double)(pitchEstimate = (float)((double)this.sampleRate / (period = (double)this.periodEstimates.get(periodIndex).floatValue()))) > 80.0 ? pitchEstimate : -1.0f;
        }
        this.result.setProbability((float)highestAmplitude);
        this.result.setPitch(pitch);
        this.result.setPitched(pitch != -1.0f);
        return this.result;
    }

    private void parabolicInterpolation(int tau) {
        float nsdfa = this.nsdf[tau - 1];
        float nsdfb = this.nsdf[tau];
        float nsdfc = this.nsdf[tau + 1];
        float bValue = tau;
        float bottom = nsdfc + nsdfa - 2.0f * nsdfb;
        if ((double)bottom == 0.0) {
            this.turningPointX = bValue;
            this.turningPointY = nsdfb;
        } else {
            float delta = nsdfa - nsdfc;
            this.turningPointX = bValue + delta / (2.0f * bottom);
            this.turningPointY = nsdfb - delta * delta / (8.0f * bottom);
        }
    }

    private void peakPicking() {
        int pos;
        int curMaxPos = 0;
        for (pos = 0; pos < (this.nsdf.length - 1) / 3 && this.nsdf[pos] > 0.0f; ++pos) {
        }
        while (pos < this.nsdf.length - 1 && (double)this.nsdf[pos] <= 0.0) {
            ++pos;
        }
        if (pos == 0) {
            pos = 1;
        }
        while (pos < this.nsdf.length - 1) {
            assert (this.nsdf[pos] >= 0.0f);
            if (this.nsdf[pos] > this.nsdf[pos - 1] && this.nsdf[pos] >= this.nsdf[pos + 1]) {
                if (curMaxPos == 0) {
                    curMaxPos = pos;
                } else if (this.nsdf[pos] > this.nsdf[curMaxPos]) {
                    curMaxPos = pos;
                }
            }
            if (++pos >= this.nsdf.length - 1 || !(this.nsdf[pos] <= 0.0f)) continue;
            if (curMaxPos > 0) {
                this.maxPositions.add(curMaxPos);
                curMaxPos = 0;
            }
            while (pos < this.nsdf.length - 1 && this.nsdf[pos] <= 0.0f) {
                ++pos;
            }
        }
        if (curMaxPos > 0) {
            this.maxPositions.add(curMaxPos);
        }
    }
}

