/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.mfcc;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.HammingWindow;

public class MFCC
implements AudioProcessor {
    private int amountOfCepstrumCoef;
    protected int amountOfMelFilters;
    protected float lowerFilterFreq;
    protected float upperFilterFreq;
    float[] audioFloatBuffer;
    private float[] mfcc;
    int[] centerFrequencies;
    private FFT fft;
    private int samplesPerFrame;
    private float sampleRate;

    public MFCC(int samplesPerFrame, int sampleRate) {
        this(samplesPerFrame, sampleRate, 30, 30, 133.3334f, (float)sampleRate / 2.0f);
    }

    public MFCC(int samplesPerFrame, float sampleRate, int amountOfCepstrumCoef, int amountOfMelFilters, float lowerFilterFreq, float upperFilterFreq) {
        this.samplesPerFrame = samplesPerFrame;
        this.sampleRate = sampleRate;
        this.amountOfCepstrumCoef = amountOfCepstrumCoef;
        this.amountOfMelFilters = amountOfMelFilters;
        this.fft = new FFT(samplesPerFrame, new HammingWindow());
        this.lowerFilterFreq = Math.max(lowerFilterFreq, 25.0f);
        this.upperFilterFreq = Math.min(upperFilterFreq, sampleRate / 2.0f);
        this.calculateFilterBanks();
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        this.audioFloatBuffer = (float[])audioEvent.getFloatBuffer().clone();
        float[] bin = this.magnitudeSpectrum(this.audioFloatBuffer);
        float[] fbank = this.melFilter(bin, this.centerFrequencies);
        float[] f = this.nonLinearTransformation(fbank);
        this.mfcc = this.cepCoefficients(f);
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public float[] magnitudeSpectrum(float[] frame) {
        float[] magSpectrum = new float[frame.length];
        this.fft.forwardTransform(frame);
        for (int k = 0; k < frame.length / 2; ++k) {
            magSpectrum[frame.length / 2 + k] = this.fft.modulus(frame, frame.length / 2 - 1 - k);
            magSpectrum[frame.length / 2 - 1 - k] = magSpectrum[frame.length / 2 + k];
        }
        return magSpectrum;
    }

    public final void calculateFilterBanks() {
        this.centerFrequencies = new int[this.amountOfMelFilters + 2];
        this.centerFrequencies[0] = Math.round(this.lowerFilterFreq / this.sampleRate * (float)this.samplesPerFrame);
        this.centerFrequencies[this.centerFrequencies.length - 1] = this.samplesPerFrame / 2;
        double[] mel = new double[]{MFCC.freqToMel(this.lowerFilterFreq), MFCC.freqToMel(this.upperFilterFreq)};
        float factor = (float)((mel[1] - mel[0]) / (double)(this.amountOfMelFilters + 1));
        for (int i = 1; i <= this.amountOfMelFilters; ++i) {
            float fc = MFCC.inverseMel(mel[0] + (double)(factor * (float)i)) / this.sampleRate * (float)this.samplesPerFrame;
            this.centerFrequencies[i] = Math.round(fc);
        }
    }

    public float[] nonLinearTransformation(float[] fbank) {
        float[] f = new float[fbank.length];
        float FLOOR = -50.0f;
        for (int i = 0; i < fbank.length; ++i) {
            f[i] = (float)Math.log(fbank[i]);
            if (!(f[i] < -50.0f)) continue;
            f[i] = -50.0f;
        }
        return f;
    }

    public float[] melFilter(float[] bin, int[] centerFrequencies) {
        float[] temp = new float[this.amountOfMelFilters + 2];
        for (int k = 1; k <= this.amountOfMelFilters; ++k) {
            int i;
            float num1 = 0.0f;
            float num2 = 0.0f;
            float den = centerFrequencies[k] - centerFrequencies[k - 1] + 1;
            for (i = centerFrequencies[k - 1]; i <= centerFrequencies[k]; ++i) {
                num1 += bin[i] * (float)(i - centerFrequencies[k - 1] + 1);
            }
            num1 /= den;
            den = centerFrequencies[k + 1] - centerFrequencies[k] + 1;
            for (i = centerFrequencies[k] + 1; i <= centerFrequencies[k + 1]; ++i) {
                num2 += bin[i] * (1.0f - (float)(i - centerFrequencies[k]) / den);
            }
            temp[k] = num1 + num2;
        }
        float[] fbank = new float[this.amountOfMelFilters];
        for (int i = 0; i < this.amountOfMelFilters; ++i) {
            fbank[i] = temp[i + 1];
        }
        return fbank;
    }

    public float[] cepCoefficients(float[] f) {
        float[] cepc = new float[this.amountOfCepstrumCoef];
        for (int i = 0; i < cepc.length; ++i) {
            for (int j = 0; j < f.length; ++j) {
                int n = i;
                cepc[n] = (float)((double)cepc[n] + (double)f[j] * Math.cos(Math.PI * (double)i / (double)f.length * ((double)j + 0.5)));
            }
        }
        return cepc;
    }

    protected static float freqToMel(float freq) {
        return 2595.0f * MFCC.log10(1.0f + freq / 700.0f);
    }

    private static float inverseMel(double x) {
        return (float)(700.0 * (Math.pow(10.0, x / 2595.0) - 1.0));
    }

    protected static float log10(float value) {
        return (float)(Math.log(value) / Math.log(10.0));
    }

    public float[] getMFCC() {
        return (float[])this.mfcc.clone();
    }

    public int[] getCenterFrequencies() {
        return this.centerFrequencies;
    }
}

