/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.granulator;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.granulator.Grain;
import be.tarsos.dsp.util.fft.CosineWindow;
import java.util.ArrayList;
import java.util.Arrays;

public class Granulator
implements AudioProcessor {
    public static final float ADAPTIVE_INTERP_LOW_THRESH = 0.5f;
    public static final float ADAPTIVE_INTERP_HIGH_THRESH = 2.5f;
    protected double position;
    private double positionIncrement;
    private float grainInterval;
    private float grainSize;
    private float grainRandomness;
    private float timeSinceLastGrain;
    private double msPerSample;
    private float pitchFactor;
    private float timeStretchFactor;
    private ArrayList<Grain> grains = new ArrayList();
    private ArrayList<Grain> freeGrains = new ArrayList();
    private ArrayList<Grain> deadGrains = new ArrayList();
    private final float[] window;
    private final float[] audioBuffer;
    private int audioBufferWatermark;
    private final float[] outputBuffer;
    private boolean firstGrain = true;

    public Granulator(float sampleRate, int bufferSize) {
        this.audioBuffer = new float[(int)(720.0f * sampleRate)];
        this.audioBufferWatermark = 0;
        this.pitchFactor = 1.0f;
        this.grainInterval = 40.0f;
        this.grainSize = 100.0f;
        this.grainRandomness = 0.1f;
        this.window = new CosineWindow().generateCurve(bufferSize);
        this.outputBuffer = new float[bufferSize];
        this.positionIncrement = this.msPerSample = (double)(1000.0f / sampleRate);
    }

    public void start() {
        this.timeSinceLastGrain = 0.0f;
    }

    private void firstGrain() {
        if (this.firstGrain) {
            Grain g = new Grain();
            g.position = this.position;
            g.age = this.grainSize / 4.0f;
            g.grainSize = this.grainSize;
            this.grains.add(g);
            this.firstGrain = false;
            this.timeSinceLastGrain = this.grainInterval / 2.0f;
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        System.arraycopy(audioEvent.getFloatBuffer(), 0, this.audioBuffer, this.audioBufferWatermark, audioEvent.getBufferSize());
        this.audioBufferWatermark += audioEvent.getBufferSize();
        Arrays.fill(this.outputBuffer, 0.0f);
        this.firstGrain();
        int bufferSize = audioEvent.getBufferSize();
        for (int i = 0; i < bufferSize; ++i) {
            Grain g;
            int gi;
            if (this.timeSinceLastGrain > this.grainInterval) {
                Grain g2 = null;
                if (this.freeGrains.size() > 0) {
                    g2 = this.freeGrains.get(0);
                    this.freeGrains.remove(0);
                } else {
                    g2 = new Grain();
                }
                g2.reset(this.grainSize, this.grainRandomness, this.position, this.timeStretchFactor, this.pitchFactor);
                this.grains.add(g2);
                this.timeSinceLastGrain = 0.0f;
            }
            for (gi = 0; gi < this.grains.size(); ++gi) {
                g = this.grains.get(gi);
                float windowScale = this.getValueFraction((float)(g.age / g.grainSize));
                this.getFrameLinear(g.position);
                double sampleValue = this.pitchFactor > 2.5f ? (double)this.getFrameNoInterp(g.position) : (this.pitchFactor > 0.5f ? this.getFrameLinear(g.position) : (double)this.getFrameCubic(g.position));
                int n = i;
                this.outputBuffer[n] = this.outputBuffer[n] + (float)(sampleValue *= (double)windowScale);
            }
            this.position += this.positionIncrement * (double)this.timeStretchFactor;
            for (gi = 0; gi < this.grains.size(); ++gi) {
                g = this.grains.get(gi);
                this.calculateNextGrainPosition(g);
            }
            this.timeSinceLastGrain = (float)((double)this.timeSinceLastGrain + this.msPerSample);
            for (gi = 0; gi < this.grains.size(); ++gi) {
                g = this.grains.get(gi);
                if (!(g.age > g.grainSize)) continue;
                this.freeGrains.add(g);
                this.deadGrains.add(g);
            }
            for (gi = 0; gi < this.deadGrains.size(); ++gi) {
                g = this.deadGrains.get(gi);
                this.grains.remove(g);
            }
            this.deadGrains.clear();
        }
        audioEvent.setFloatBuffer(this.outputBuffer);
        return true;
    }

    public double getFrameLinear(double posInMS) {
        double result = 0.0;
        double sampleNumber = this.msToSamples(posInMS);
        int sampleNumberFloor = (int)Math.floor(sampleNumber);
        if (sampleNumberFloor > 0 && sampleNumberFloor < this.audioBufferWatermark) {
            double sampleNumberFraction = sampleNumber - (double)sampleNumberFloor;
            if (sampleNumberFloor == this.audioBufferWatermark - 1) {
                result = this.audioBuffer[sampleNumberFloor];
            } else {
                double current = this.audioBuffer[sampleNumberFloor];
                double next = this.audioBuffer[sampleNumberFloor];
                result = (float)((1.0 - sampleNumberFraction) * current + sampleNumberFraction * next);
            }
        }
        return result;
    }

    public float getFrameNoInterp(double posInMS) {
        double frame = this.msToSamples(posInMS);
        int frame_floor = (int)Math.floor(frame);
        return this.audioBuffer[frame_floor];
    }

    public float getFrameCubic(double posInMS) {
        float frame = (float)this.msToSamples(posInMS);
        float result = 0.0f;
        int realCurrentSample = (int)Math.floor(frame);
        float fractionOffset = frame - (float)realCurrentSample;
        if (realCurrentSample >= 0 && realCurrentSample < this.audioBufferWatermark - 1) {
            float ym1;
            if (--realCurrentSample < 0) {
                ym1 = this.audioBuffer[0];
                realCurrentSample = 0;
            } else {
                ym1 = this.audioBuffer[realCurrentSample++];
            }
            float y0 = this.audioBuffer[realCurrentSample++];
            float y1 = realCurrentSample >= this.audioBufferWatermark ? this.audioBuffer[this.audioBufferWatermark - 1] : this.audioBuffer[realCurrentSample++];
            float y2 = realCurrentSample >= this.audioBufferWatermark ? this.audioBuffer[this.audioBufferWatermark - 1] : this.audioBuffer[realCurrentSample++];
            float mu2 = fractionOffset * fractionOffset;
            float a0 = y2 - y1 - ym1 + y0;
            float a1 = ym1 - y0 - a0;
            float a2 = y1 - ym1;
            float a3 = y0;
            result = a0 * fractionOffset * mu2 + a1 * mu2 + a2 * fractionOffset + a3;
        }
        return result;
    }

    private double msToSamples(double posInMs) {
        return posInMs / this.msPerSample;
    }

    @Override
    public void processingFinished() {
    }

    public float getValueFraction(float fraction) {
        float posInBuf = fraction * (float)this.window.length;
        int lowerIndex = (int)posInBuf;
        float offset = posInBuf - (float)lowerIndex;
        int upperIndex = (lowerIndex + 1) % this.window.length;
        return (1.0f - offset) * this.window[lowerIndex] + offset * this.window[upperIndex];
    }

    private void calculateNextGrainPosition(Grain g) {
        int direction = this.timeStretchFactor >= 0.0f ? 1 : -1;
        g.age += this.msPerSample;
        g.position += (double)direction * this.positionIncrement * (double)this.pitchFactor;
    }

    public void setTimestretchFactor(float currentFactor) {
        this.timeStretchFactor = currentFactor;
    }

    public void setPitchShiftFactor(float currentFactor) {
        this.pitchFactor = currentFactor;
    }

    public void setGrainInterval(int grainInterval) {
        this.grainInterval = grainInterval;
    }

    public void setGrainSize(int grainSize) {
        this.grainSize = grainSize;
    }

    public void setGrainRandomness(float grainRandomness) {
        this.grainRandomness = grainRandomness;
    }

    public void setPosition(float position) {
        this.position = position * 1000.0f;
    }
}

