/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.effects;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class FlangerEffect
implements AudioProcessor {
    private float[] flangerBuffer;
    private int writePosition;
    private float dry;
    private float wet;
    private double lfoFrequency;
    private double sampleRate;

    public FlangerEffect(double maxFlangerLength, double wet, double sampleRate, double lfoFrequency) {
        this.flangerBuffer = new float[(int)(sampleRate * maxFlangerLength)];
        this.sampleRate = sampleRate;
        this.lfoFrequency = lfoFrequency;
        this.wet = (float)wet;
        this.dry = (float)(1.0 - wet);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioFloatBuffer = audioEvent.getFloatBuffer();
        int overlap = audioEvent.getOverlap();
        double twoPIf = Math.PI * 2 * this.lfoFrequency / 2.0;
        double time = audioEvent.getTimeStamp();
        double timeStep = 1.0 / this.sampleRate;
        for (int i = overlap; i < audioFloatBuffer.length; ++i) {
            double lfoValue = (double)(this.flangerBuffer.length - 1) * Math.sin(twoPIf * time);
            time += timeStep;
            int delay = (int)Math.round(Math.abs(lfoValue));
            if (this.writePosition >= this.flangerBuffer.length) {
                this.writePosition = 0;
            }
            this.flangerBuffer[this.writePosition] = audioFloatBuffer[i];
            int readPosition = this.writePosition - delay;
            if (readPosition < 0) {
                readPosition += this.flangerBuffer.length;
            }
            ++this.writePosition;
            audioFloatBuffer[i] = this.dry * audioFloatBuffer[i] + this.wet * this.flangerBuffer[readPosition];
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public void setFlangerLength(double flangerLength) {
        this.flangerBuffer = new float[(int)(this.sampleRate * flangerLength)];
    }

    public void setLFOFrequency(double lfoFrequency) {
        this.lfoFrequency = lfoFrequency;
    }

    public void setWet(double wet) {
        this.wet = (float)wet;
        this.dry = (float)(1.0 - wet);
    }

    public void setDry(double dry) {
        this.dry = (float)dry;
        this.wet = (float)(1.0 - dry);
    }
}

