/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Agent;
import be.tarsos.dsp.beatroot.AgentList;
import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.EventList;
import be.tarsos.dsp.beatroot.Induction;
import be.tarsos.dsp.onsets.OnsetHandler;
import java.util.Iterator;

public class BeatRootOnsetEventHandler
implements OnsetHandler {
    private final EventList onsetList = new EventList();

    @Override
    public void handleOnset(double time, double salience) {
        double roundedTime = (double)Math.round(time * 100.0) / 100.0;
        Event e = this.newEvent(roundedTime, 0);
        e.salience = salience;
        this.onsetList.add(e);
    }

    private Event newEvent(double time, int beatNum) {
        return new Event(time, time, time, 56, 64, beatNum, 0.0, 1);
    }

    public void trackBeats(OnsetHandler beatHandler) {
        AgentList agents = null;
        agents = Induction.beatInduction(this.onsetList);
        agents.beatTrack(this.onsetList, -1.0);
        Agent best = agents.bestAgent();
        if (best != null) {
            best.fillBeats(-1.0);
            EventList beats = best.events;
            Iterator<Event> eventIterator = beats.iterator();
            while (eventIterator.hasNext()) {
                Event beat = eventIterator.next();
                double time = beat.keyDown;
                beatHandler.handleOnset(time, -1.0);
            }
        } else {
            System.err.println("No best agent");
        }
    }
}

