/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class ZeroCrossingRateProcessor
implements AudioProcessor {
    private float zeroCrossingRate = 0.0f;

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] buffer = audioEvent.getFloatBuffer();
        int numberOfZeroCrossings = 0;
        for (int i = 1; i < buffer.length; ++i) {
            if (!(buffer[i] * buffer[i - 1] < 0.0f)) continue;
            ++numberOfZeroCrossings;
        }
        this.zeroCrossingRate = (float)numberOfZeroCrossings / (float)(buffer.length - 1);
        return true;
    }

    public float getZeroCrossingRate() {
        return this.zeroCrossingRate;
    }

    @Override
    public void processingFinished() {
    }
}

