/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class SilenceDetector
implements AudioProcessor {
    public static final double DEFAULT_SILENCE_THRESHOLD = -70.0;
    private final double threshold;
    private final boolean breakProcessingQueueOnSilence;
    double currentSPL = 0.0;

    public SilenceDetector() {
        this(-70.0, false);
    }

    public SilenceDetector(double silenceThreshold, boolean breakProcessingQueueOnSilence) {
        this.threshold = silenceThreshold;
        this.breakProcessingQueueOnSilence = breakProcessingQueueOnSilence;
    }

    public static double calculateRMS(float[] floatBuffer) {
        double rms = 0.0;
        for (int i = 0; i < floatBuffer.length; ++i) {
            rms += (double)(floatBuffer[i] * floatBuffer[i]);
        }
        rms /= Double.valueOf(floatBuffer.length).doubleValue();
        rms = Math.sqrt(rms);
        return rms;
    }

    private static double soundPressureLevel(float[] buffer) {
        double rms = SilenceDetector.calculateRMS(buffer);
        return SilenceDetector.linearToDecibel(rms);
    }

    private static double linearToDecibel(double value) {
        return 20.0 * Math.log10(value);
    }

    public double currentSPL() {
        return this.currentSPL;
    }

    public boolean isSilence(float[] buffer, double silenceThreshold) {
        this.currentSPL = SilenceDetector.soundPressureLevel(buffer);
        return this.currentSPL < silenceThreshold;
    }

    public boolean isSilence(float[] buffer) {
        return this.isSilence(buffer, this.threshold);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        boolean isSilence = this.isSilence(audioEvent.getFloatBuffer());
        if (this.breakProcessingQueueOnSilence) {
            return !isSilence;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

