/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class MultichannelToMono
implements AudioProcessor {
    private int channels;
    private boolean mean;

    public MultichannelToMono(int numberOfChannels, boolean meanOfchannels) {
        this.channels = numberOfChannels;
        this.mean = meanOfchannels;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] buffer = audioEvent.getFloatBuffer();
        float[] newBuffer = new float[buffer.length / this.channels];
        if (this.mean) {
            if (this.channels == 2) {
                for (int i = 0; i < buffer.length; i += this.channels) {
                    newBuffer[i / this.channels] = (buffer[i] + buffer[i + 1]) / 2.0f;
                }
            } else {
                for (int i = 0; i < buffer.length; i += this.channels) {
                    double sum = 0.0;
                    for (int j = 0; j < this.channels; ++j) {
                        sum += (double)buffer[i + j];
                    }
                    newBuffer[i / this.channels] = (float)(sum / (double)this.channels);
                }
            }
        } else {
            for (int i = 0; i < buffer.length; i += this.channels) {
                newBuffer[i / this.channels] = buffer[i];
            }
        }
        audioEvent.setFloatBuffer(newBuffer);
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

