/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.GainProcessor;

public class FadeIn
implements AudioProcessor {
    private double duration;
    private double firstTime = -1.0;
    private double time;
    private GainProcessor gp = new GainProcessor(0.1);
    private boolean fadingIn = true;

    public FadeIn(double d) {
        this.duration = d;
    }

    public void stopFadeIn() {
        this.fadingIn = false;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        if (this.fadingIn) {
            if (this.firstTime == -1.0) {
                this.firstTime = audioEvent.getTimeStamp();
            }
            this.time = audioEvent.getTimeStamp() - this.firstTime;
            this.gp.setGain(this.time / this.duration);
            this.gp.process(audioEvent);
            if (this.time > this.duration) {
                this.fadingIn = false;
            }
        }
        return true;
    }

    @Override
    public void processingFinished() {
        this.gp.processingFinished();
    }
}

