/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class AudioGenerator
implements Runnable {
    private static final Logger LOG = Logger.getLogger(AudioGenerator.class.getName());
    private float[] audioFloatBuffer;
    private final List<AudioProcessor> audioProcessors = new CopyOnWriteArrayList<AudioProcessor>();
    private final TarsosDSPAudioFormat format;
    private int floatOverlap;
    private int floatStepSize;
    private int samplesProcessed;
    private AudioEvent audioEvent;
    private boolean stopped;

    public AudioGenerator(int audioBufferSize, int bufferOverlap) {
        this(audioBufferSize, bufferOverlap, 44100);
    }

    public AudioGenerator(int audioBufferSize, int bufferOverlap, int samplerate) {
        this.format = this.getTargetAudioFormat(samplerate);
        this.setStepSizeAndOverlap(audioBufferSize, bufferOverlap);
        this.audioEvent = new AudioEvent(this.format);
        this.audioEvent.setFloatBuffer(this.audioFloatBuffer);
        this.stopped = false;
        this.samplesProcessed = 0;
    }

    private TarsosDSPAudioFormat getTargetAudioFormat(int targetSampleRate) {
        TarsosDSPAudioFormat audioFormat = new TarsosDSPAudioFormat(TarsosDSPAudioFormat.Encoding.PCM_SIGNED, targetSampleRate, 16, 1, 2, targetSampleRate, ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder()));
        return audioFormat;
    }

    public void setStepSizeAndOverlap(int audioBufferSize, int bufferOverlap) {
        this.audioFloatBuffer = new float[audioBufferSize];
        this.floatOverlap = bufferOverlap;
        this.floatStepSize = this.audioFloatBuffer.length - this.floatOverlap;
    }

    public void addAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessors.add(audioProcessor);
        LOG.fine("Added an audioprocessor to the list of processors: " + audioProcessor.toString());
    }

    public void removeAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessors.remove(audioProcessor);
        audioProcessor.processingFinished();
        LOG.fine("Remove an audioprocessor to the list of processors: " + audioProcessor.toString());
    }

    @Override
    public void run() {
        this.generateNextAudioBlock();
        while (!this.stopped) {
            for (AudioProcessor processor : this.audioProcessors) {
                if (!processor.process(this.audioEvent)) break;
            }
            if (this.stopped) continue;
            this.audioEvent.setBytesProcessed(this.samplesProcessed * this.format.getFrameSize());
            this.generateNextAudioBlock();
        }
        if (!this.stopped) {
            this.stop();
        }
    }

    public void stop() {
        this.stopped = true;
        for (AudioProcessor processor : this.audioProcessors) {
            processor.processingFinished();
        }
    }

    private void generateNextAudioBlock() {
        assert (this.floatOverlap < this.audioFloatBuffer.length);
        if (this.audioFloatBuffer.length == this.floatOverlap + this.floatStepSize) {
            System.arraycopy(this.audioFloatBuffer, this.floatStepSize, this.audioFloatBuffer, 0, this.floatOverlap);
        }
        this.samplesProcessed += this.floatStepSize;
    }

    public void resetTime() {
        this.samplesProcessed = 0;
    }

    public TarsosDSPAudioFormat getFormat() {
        return this.format;
    }

    public float secondsProcessed() {
        return (float)this.samplesProcessed / this.format.getSampleRate() / (float)this.format.getChannels();
    }
}

