/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.io.TarsosDSPAudioFloatConverter;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import java.util.Arrays;

public class AudioEvent {
    private final TarsosDSPAudioFormat format;
    private final TarsosDSPAudioFloatConverter converter;
    private float[] floatBuffer;
    private byte[] byteBuffer;
    private int overlap;
    private long frameLength;
    private long bytesProcessed;
    private int bytesProcessing;

    public AudioEvent(TarsosDSPAudioFormat format) {
        this.format = format;
        this.converter = TarsosDSPAudioFloatConverter.getConverter(format);
        this.overlap = 0;
    }

    public float getSampleRate() {
        return this.format.getSampleRate();
    }

    public int getBufferSize() {
        return this.getFloatBuffer().length;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public void setOverlap(int newOverlap) {
        this.overlap = newOverlap;
    }

    public void setBytesProcessed(long bytesProcessed) {
        this.bytesProcessed = bytesProcessed;
    }

    public double getTimeStamp() {
        return (float)(this.bytesProcessed / (long)this.format.getFrameSize()) / this.format.getSampleRate();
    }

    public double getEndTimeStamp() {
        return (float)((this.bytesProcessed + (long)this.bytesProcessing) / (long)this.format.getFrameSize()) / this.format.getSampleRate();
    }

    public long getSamplesProcessed() {
        return this.bytesProcessed / (long)this.format.getFrameSize();
    }

    public double getProgress() {
        return (double)(this.bytesProcessed / (long)this.format.getFrameSize()) / (double)this.frameLength;
    }

    public byte[] getByteBuffer() {
        int length = this.getFloatBuffer().length * this.format.getFrameSize();
        if (this.byteBuffer == null || this.byteBuffer.length != length) {
            this.byteBuffer = new byte[length];
        }
        this.converter.toByteArray(this.getFloatBuffer(), this.byteBuffer);
        return this.byteBuffer;
    }

    public void setFloatBuffer(float[] floatBuffer) {
        this.floatBuffer = floatBuffer;
    }

    public float[] getFloatBuffer() {
        return this.floatBuffer;
    }

    public double getRMS() {
        return AudioEvent.calculateRMS(this.floatBuffer);
    }

    public double getdBSPL() {
        return AudioEvent.soundPressureLevel(this.floatBuffer);
    }

    public static double calculateRMS(float[] floatBuffer) {
        double rms = 0.0;
        for (int i = 0; i < floatBuffer.length; ++i) {
            rms += (double)(floatBuffer[i] * floatBuffer[i]);
        }
        rms /= Double.valueOf(floatBuffer.length).doubleValue();
        rms = Math.sqrt(rms);
        return rms;
    }

    public void clearFloatBuffer() {
        Arrays.fill(this.floatBuffer, 0.0f);
    }

    private static double soundPressureLevel(float[] buffer) {
        double rms = AudioEvent.calculateRMS(buffer);
        return AudioEvent.linearToDecibel(rms);
    }

    private static double linearToDecibel(double value) {
        return 20.0 * Math.log10(value);
    }

    public boolean isSilence(double silenceThreshold) {
        return AudioEvent.soundPressureLevel(this.floatBuffer) < silenceThreshold;
    }

    public void setBytesProcessing(int bytesProcessing) {
        this.bytesProcessing = bytesProcessing;
    }
}

