/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.easing;

import java.util.HashMap;
import net.minecraft.util.Mth;

public abstract class Easing {
    public static final HashMap<String, Easing> EASINGS = new HashMap();
    public final String name;
    public static final Easing LINEAR = new Easing("linear"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return max * value / time + min;
        }
    };
    public static final Easing QUAD_IN = new Easing("quadIn"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return max * (value /= time) * value + min;
        }
    };
    public static final Easing QUAD_OUT = new Easing("quadOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return -max * (value /= time) * (value - 2.0f) + min;
        }
    };
    public static final Easing QUAD_IN_OUT = new Easing("quadInOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            float f;
            value /= time / 2.0f;
            if (f < 1.0f) {
                return max / 2.0f * value * value + min;
            }
            return -max / 2.0f * ((value -= 1.0f) * (value - 2.0f) - 1.0f) + min;
        }
    };
    public static final Easing CUBIC_IN = new Easing("cubicIn"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return max * (value /= time) * value * value + min;
        }
    };
    public static final Easing CUBIC_OUT = new Easing("cubicOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            value = value / time - 1.0f;
            return max * (value * value * value + 1.0f) + min;
        }
    };
    public static final Easing CUBIC_IN_OUT = new Easing("cubicInOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            float f;
            value /= time / 2.0f;
            if (f < 1.0f) {
                return max / 2.0f * value * value * value + min;
            }
            return max / 2.0f * ((value -= 2.0f) * value * value + 2.0f) + min;
        }
    };
    public static final Easing QUARTIC_IN = new Easing("quarticIn"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return max * (value /= time) * value * value * value + min;
        }
    };
    public static final Easing QUARTIC_OUT = new Easing("quarticOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            value = value / time - 1.0f;
            return -max * (value * value * value * value - 1.0f) + min;
        }
    };
    public static final Easing QUARTIC_IN_OUT = new Easing("quarticInOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            float f;
            value /= time / 2.0f;
            if (f < 1.0f) {
                return max / 2.0f * value * value * value * value + min;
            }
            return -max / 2.0f * ((value -= 2.0f) * value * value * value - 2.0f) + min;
        }
    };
    public static final Easing QUINTIC_IN = new Easing("quinticIn"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return max * (value /= time) * value * value * value * value + min;
        }
    };
    public static final Easing QUINTIC_OUT = new Easing("quinticOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            value = value / time - 1.0f;
            return max * (value * value * value * value * value + 1.0f) + min;
        }
    };
    public static final Easing QUINTIC_IN_OUT = new Easing("quinticInOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            float f;
            value /= time / 2.0f;
            if (f < 1.0f) {
                return max / 2.0f * value * value * value * value * value + min;
            }
            return max / 2.0f * ((value -= 2.0f) * value * value * value * value + 2.0f) + min;
        }
    };
    public static final Easing SINE_IN = new Easing("sineIn"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return -max * (float)Math.cos((double)(value / time) * 1.5707963267948966) + max + min;
        }
    };
    public static final Easing SINE_OUT = new Easing("sineOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return max * (float)Math.sin((double)(value / time) * 1.5707963267948966) + min;
        }
    };
    public static final Easing SINE_IN_OUT = new Easing("sineInOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return -max / 2.0f * ((float)Math.cos(Math.PI * (double)value / (double)time) - 1.0f) + min;
        }
    };
    public static final Easing EXPO_IN = new Easing("expoIn"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return value == 0.0f ? min : max * (float)Math.pow(2.0, 10.0f * (value / time - 1.0f)) + min;
        }
    };
    public static final Easing EXPO_OUT = new Easing("expoOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return value == time ? min + max : max * (-((float)Math.pow(2.0, -10.0f * value / time)) + 1.0f) + min;
        }
    };
    public static final Easing EXPO_IN_OUT = new Easing("expoInOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            float f;
            if (value == 0.0f) {
                return min;
            }
            if (value == time) {
                return min + max;
            }
            value /= time / 2.0f;
            if (f < 1.0f) {
                return max / 2.0f * (float)Math.pow(2.0, 10.0f * (value - 1.0f)) + min;
            }
            return max / 2.0f * (-((float)Math.pow(2.0, -10.0f * (value -= 1.0f))) + 2.0f) + min;
        }
    };
    public static final Easing CIRC_IN = new Easing("circIn"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return -max * ((float)Math.sqrt(1.0f - (value /= time) * value) - 1.0f) + min;
        }
    };
    public static final Easing CIRC_OUT = new Easing("circOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            value = value / time - 1.0f;
            return max * (float)Math.sqrt(1.0f - value * value) + min;
        }
    };
    public static final Easing CIRC_IN_OUT = new Easing("circInOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            float f;
            value /= time / 2.0f;
            if (f < 1.0f) {
                return -max / 2.0f * ((float)Math.sqrt(1.0f - value * value) - 1.0f) + min;
            }
            return max / 2.0f * ((float)Math.sqrt(1.0f - (value -= 2.0f) * value) + 1.0f) + min;
        }
    };
    public static final Elastic ELASTIC_IN = new ElasticIn();
    public static final Elastic ELASTIC_OUT = new ElasticOut();
    public static final Elastic ELASTIC_IN_OUT = new ElasticInOut();
    public static final Back BACK_IN = new BackIn();
    public static final Back BACK_OUT = new BackOut();
    public static final Back BACK_IN_OUT = new BackInOut();
    public static final Easing BOUNCE_IN = new Easing("bounceIn"){

        @Override
        public float ease(float value, float min, float max, float time) {
            return max - BOUNCE_OUT.ease(time - value, 0.0f, max, time) + min;
        }
    };
    public static final Easing BOUNCE_OUT = new Easing("bounceOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            float f;
            value /= time;
            if (f < 0.36363637f) {
                return max * (7.5625f * value * value) + min;
            }
            if (value < 0.72727275f) {
                return max * (7.5625f * (value -= 0.54545456f) * value + 0.75f) + min;
            }
            if (value < 0.90909094f) {
                return max * (7.5625f * (value -= 0.8181818f) * value + 0.9375f) + min;
            }
            return max * (7.5625f * (value -= 0.95454544f) * value + 0.984375f) + min;
        }
    };
    public static final Easing BOUNCE_IN_OUT = new Easing("bounceInOut"){

        @Override
        public float ease(float value, float min, float max, float time) {
            if (value < time / 2.0f) {
                return BOUNCE_IN.ease(value * 2.0f, 0.0f, max, time) * 0.5f + min;
            }
            return BOUNCE_OUT.ease(value * 2.0f - time, 0.0f, max, time) * 0.5f + max * 0.5f + min;
        }
    };

    public Easing(String name) {
        this.name = name;
        EASINGS.put(name, this);
    }

    public static Easing valueOf(String name) {
        return EASINGS.get(name);
    }

    public abstract float ease(float var1, float var2, float var3, float var4);

    public float ease(double value, double min, double max, double time) {
        return this.ease((float)value, (float)min, (float)max, (float)time);
    }

    public float ease(float value, float min, float max) {
        return this.ease(value, min, max, 1.0f);
    }

    public float ease(double value, double min, double max) {
        return this.ease(value, min, max, 1.0);
    }

    public float clamped(float value, float min, float max, float time) {
        return this.ease(Mth.m_14036_((float)value, (float)0.0f, (float)time), min, max, time);
    }

    public float clamped(double value, double min, double max, double time) {
        return this.clamped((float)value, (float)min, (float)max, (float)time);
    }

    public float clamped(float value, float min, float max) {
        return this.clamped(value, min, max, 1.0f);
    }

    public float clamped(double value, double min, double max) {
        return this.clamped(value, min, max, 1.0);
    }

    public static class ElasticIn
    extends Elastic {
        public ElasticIn(float amplitude, float period) {
            super("elasticIn", amplitude, period);
        }

        public ElasticIn() {
            super("elasticIn");
        }

        @Override
        public float ease(float value, float min, float max, float time) {
            float a = this.getAmplitude();
            float p = this.getPeriod();
            if (value == 0.0f) {
                return min;
            }
            if ((value /= time) == 1.0f) {
                return min + max;
            }
            if (p == 0.0f) {
                p = time * 0.3f;
            }
            float s = 0.0f;
            if (a < Math.abs(max)) {
                a = max;
                s = p / 4.0f;
            } else {
                s = p / ((float)Math.PI * 2) * (float)Math.asin(max / a);
            }
            return -(a * (float)Math.pow(2.0, 10.0f * (value -= 1.0f)) * (float)Math.sin((double)(value * time - s) * (Math.PI * 2) / (double)p)) + min;
        }
    }

    public static abstract class Elastic
    extends Easing {
        private float amplitude;
        private float period;

        public Elastic(String name, float amplitude, float period) {
            super(name);
            this.amplitude = amplitude;
            this.period = period;
        }

        public Elastic(String name) {
            this(name, -1.0f, 0.0f);
        }

        public float getPeriod() {
            return this.period;
        }

        public void setPeriod(float period) {
            this.period = period;
        }

        public float getAmplitude() {
            return this.amplitude;
        }

        public void setAmplitude(float amplitude) {
            this.amplitude = amplitude;
        }
    }

    public static class ElasticOut
    extends Elastic {
        public ElasticOut(float amplitude, float period) {
            super("elasticOut", amplitude, period);
        }

        public ElasticOut() {
            super("elasticOut");
        }

        @Override
        public float ease(float value, float min, float max, float time) {
            float a = this.getAmplitude();
            float p = this.getPeriod();
            if (value == 0.0f) {
                return min;
            }
            if ((value /= time) == 1.0f) {
                return min + max;
            }
            if (p == 0.0f) {
                p = time * 0.3f;
            }
            float s = 0.0f;
            if (a < Math.abs(max)) {
                a = max;
                s = p / 4.0f;
            } else {
                s = p / ((float)Math.PI * 2) * (float)Math.asin(max / a);
            }
            return a * (float)Math.pow(2.0, -10.0f * value) * (float)Math.sin((double)(value * time - s) * (Math.PI * 2) / (double)p) + max + min;
        }
    }

    public static class ElasticInOut
    extends Elastic {
        public ElasticInOut(float amplitude, float period) {
            super("elasticInOut", amplitude, period);
        }

        public ElasticInOut() {
            super("elasticInOut");
        }

        @Override
        public float ease(float value, float min, float max, float time) {
            float a = this.getAmplitude();
            float p = this.getPeriod();
            if (value == 0.0f) {
                return min;
            }
            if ((value /= time / 2.0f) == 2.0f) {
                return min + max;
            }
            if (p == 0.0f) {
                p = time * 0.45000002f;
            }
            float s = 0.0f;
            if (a < Math.abs(max)) {
                a = max;
                s = p / 4.0f;
            } else {
                s = p / ((float)Math.PI * 2) * (float)Math.asin(max / a);
            }
            if (value < 1.0f) {
                return -0.5f * (a * (float)Math.pow(2.0, 10.0f * (value -= 1.0f)) * (float)Math.sin((double)(value * time - s) * (Math.PI * 2) / (double)p)) + min;
            }
            return a * (float)Math.pow(2.0, -10.0f * (value -= 1.0f)) * (float)Math.sin((double)(value * time - s) * (Math.PI * 2) / (double)p) * 0.5f + max + min;
        }
    }

    public static class BackIn
    extends Back {
        public BackIn() {
            super("backIn");
        }

        public BackIn(float overshoot) {
            super("backIn", overshoot);
        }

        @Override
        public float ease(float value, float min, float max, float time) {
            float s = this.getOvershoot();
            return max * (value /= time) * value * ((s + 1.0f) * value - s) + min;
        }
    }

    public static abstract class Back
    extends Easing {
        public static final float DEFAULT_OVERSHOOT = 1.70158f;
        private float overshoot;

        public Back(String name) {
            this(name, 1.70158f);
        }

        public Back(String name, float overshoot) {
            super(name);
            this.overshoot = overshoot;
        }

        public void setOvershoot(float overshoot) {
            this.overshoot = overshoot;
        }

        public float getOvershoot() {
            return this.overshoot;
        }
    }

    public static class BackOut
    extends Back {
        public BackOut() {
            super("backOut");
        }

        public BackOut(float overshoot) {
            super("backOut", overshoot);
        }

        @Override
        public float ease(float value, float min, float max, float time) {
            float s = this.getOvershoot();
            value = value / time - 1.0f;
            return max * (value * value * ((s + 1.0f) * value + s) + 1.0f) + min;
        }
    }

    public static class BackInOut
    extends Back {
        public BackInOut() {
            super("backInOut");
        }

        public BackInOut(float overshoot) {
            super("backInOut", overshoot);
        }

        @Override
        public float ease(float value, float min, float max, float time) {
            float f;
            float s = this.getOvershoot();
            value /= time / 2.0f;
            if (f < 1.0f) {
                s = (float)((double)s * 1.525);
                return max / 2.0f * (value * value * ((s + 1.0f) * value - s)) + min;
            }
            s = (float)((double)s * 1.525);
            return max / 2.0f * ((value -= 2.0f) * value * ((s + 1.0f) * value + s) + 2.0f) + min;
        }
    }
}

