/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.itemsmith;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import team.lodestar.lodestone.systems.datagen.itemsmith.AbstractItemModelSmith;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;

public class ItemModelSmith
extends AbstractItemModelSmith {
    public final ItemModelSupplier modelSupplier;

    public ItemModelSmith(ItemModelSupplier modelSupplier) {
        this.modelSupplier = modelSupplier;
    }

    @SafeVarargs
    public final void act(AbstractItemModelSmith.ItemModelSmithData data, Supplier<? extends Item> ... items) {
        for (Supplier<? extends Item> item : items) {
            this.act(data, item);
        }
        List.of(items).forEach(data.consumer);
    }

    public void act(AbstractItemModelSmith.ItemModelSmithData data, Collection<Supplier<? extends Item>> items) {
        items.forEach(r -> this.act(data, (Supplier<? extends Item>)r));
        new ArrayList<Supplier<? extends Item>>(items).forEach(data.consumer);
    }

    private void act(AbstractItemModelSmith.ItemModelSmithData data, Supplier<? extends Item> registryObject) {
        Item item = registryObject.get();
        this.modelSupplier.act(item, data.provider);
    }

    public void act(Supplier<? extends Item> registryObject, LodestoneItemModelProvider provider) {
        Item item = registryObject.get();
        this.modelSupplier.act(item, provider);
    }

    public static interface ItemModelSupplier {
        public void act(Item var1, LodestoneItemModelProvider var2);
    }
}

