/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import team.lodestar.lodestone.registry.common.LodestoneRecipeSerializerRegistry;

public class NBTCarryRecipe
extends ShapedRecipe {
    public static final String NAME = "nbt_carry";
    public final Ingredient nbtCarry;

    public NBTCarryRecipe(ShapedRecipe compose, Ingredient nbtCarry, ItemStack output) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.m_44220_(), compose.m_44221_(), compose.m_7527_(), output);
        this.nbtCarry = nbtCarry;
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess registryAccess) {
        ItemStack out = super.m_5874_(inv, registryAccess);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !this.nbtCarry.test(stack) || !stack.m_41782_()) continue;
            out.m_41751_(stack.m_41783_());
            break;
        }
        return out;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)LodestoneRecipeSerializerRegistry.NBT_CARRY_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<NBTCarryRecipe> {
        public NBTCarryRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            return new NBTCarryRecipe((ShapedRecipe)f_44076_.m_6729_(recipeId, json), Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"nbtCarry")), ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")));
        }

        public NBTCarryRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)f_44076_.m_8005_(recipeId, buffer);
            Ingredient nbtCarry = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack stack = buffer.m_130267_();
            return new NBTCarryRecipe(recipe, nbtCarry, stack);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull NBTCarryRecipe recipe) {
            f_44076_.m_6178_(buffer, (Recipe)recipe);
            recipe.nbtCarry.m_43923_(buffer);
            buffer.m_130055_(recipe.f_44149_);
        }
    }
}

