/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.lodestar.lodestone.handlers.FireEffectHandler;
import team.lodestar.lodestone.systems.sound.ExtendedSoundType;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Unique
    private SoundType lodestone$type;

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;updateSwimming()V")})
    private void lodestone$FireEffectTicking(CallbackInfo ci) {
        FireEffectHandler.entityUpdate((Entity)this);
    }

    @Inject(method={"setSecondsOnFire"}, at={@At(value="RETURN")})
    private void lodestone$FireEffectOverride(int pSeconds, CallbackInfo ci) {
        FireEffectHandler.onVanillaFireTimeUpdate((Entity)this);
    }

    @ModifyVariable(method={"playStepSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/SoundType;getStepSound()Lnet/minecraft/sounds/SoundEvent;"))
    private SoundType lodestone$GetStepSound(SoundType type) {
        this.lodestone$type = type;
        return this.lodestone$type;
    }

    @Inject(method={"playStepSound"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V")})
    private void lodestone$CallExtendedStepSound(BlockPos pos, BlockState state, CallbackInfo ci) {
        SoundType soundType = this.lodestone$type;
        if (soundType instanceof ExtendedSoundType) {
            ExtendedSoundType extendedSoundType = (ExtendedSoundType)soundType;
            Entity entity = (Entity)this;
            extendedSoundType.onPlayStepSound(entity.m_9236_(), pos, state, entity.m_5720_());
        }
    }
}

