/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.settings;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

@ParametersAreNonnullByDefault
public class SettingsGroup {
    private String name;
    private List<SettingsUser> users;
    private final Set<FrontierSettings.Action> actions;
    private final boolean special;

    public SettingsGroup() {
        this.name = "";
        this.users = new ArrayList<SettingsUser>();
        this.actions = EnumSet.noneOf(FrontierSettings.Action.class);
        this.special = false;
    }

    public SettingsGroup(String name, boolean special) {
        this.name = name;
        this.users = new ArrayList<SettingsUser>();
        this.actions = EnumSet.noneOf(FrontierSettings.Action.class);
        this.special = special;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addAction(FrontierSettings.Action action) {
        this.actions.add(action);
    }

    public List<SettingsUser> getUsers() {
        return this.users;
    }

    public void removeAction(FrontierSettings.Action action) {
        this.actions.remove((Object)action);
    }

    public boolean hasAction(FrontierSettings.Action action) {
        return this.actions.contains((Object)action);
    }

    public Set<FrontierSettings.Action> getActions() {
        return this.actions;
    }

    public void addUser(SettingsUser user) {
        this.users.add(user);
    }

    public void removeUser(SettingsUser user) {
        this.users.remove(user);
    }

    public boolean hasUser(SettingsUser user) {
        return this.users.contains(user);
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void readFromNBT(CompoundTag nbt, int version) {
        int i;
        if (!this.special) {
            this.name = nbt.m_128461_("name");
            this.users.clear();
            ListTag usersTagList = nbt.m_128437_("users", 10);
            for (i = 0; i < usersTagList.size(); ++i) {
                SettingsUser user = new SettingsUser();
                CompoundTag userTag = usersTagList.m_128728_(i);
                user.readFromNBT(userTag);
                this.users.add(user);
            }
        }
        this.actions.clear();
        ListTag actionsTagList = nbt.m_128437_("actions", 8);
        for (i = 0; i < actionsTagList.size(); ++i) {
            String actionTag = actionsTagList.m_128778_(i);
            List<FrontierSettings.Action> availableActions = FrontierSettings.getAvailableActions(this.name);
            try {
                FrontierSettings.Action action = version > 3 ? FrontierSettings.Action.valueOf(actionTag) : FrontierSettings.ActionV3.valueOf(actionTag).toAction();
                if (!availableActions.contains((Object)action)) {
                    throw new IllegalArgumentException();
                }
                this.actions.add(action);
                continue;
            }
            catch (IllegalArgumentException e) {
                String availableActionsString = version > 3 ? StringHelper.enumValuesToString(availableActions) : StringHelper.enumValuesToString(FrontierSettings.getAvailableActionsV3(this.name));
                MapFrontiers.LOGGER.warn(String.format("Unknown action in group %1$s. Found: \"%2$s\". Expected: %3$s", this.name, actionTag, availableActionsString));
            }
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        if (!this.special) {
            nbt.m_128359_("name", this.name);
            ListTag usersTagList = new ListTag();
            for (SettingsUser user : this.users) {
                CompoundTag userTag = new CompoundTag();
                user.writeToNBT(userTag);
                usersTagList.add((Object)userTag);
            }
            nbt.m_128365_("users", (Tag)usersTagList);
        }
        ListTag actionsTagList = new ListTag();
        for (FrontierSettings.Action action : this.actions) {
            StringTag actionTag = StringTag.m_129297_((String)action.name());
            actionsTagList.add((Object)actionTag);
        }
        nbt.m_128365_("actions", (Tag)actionsTagList);
    }

    public void fromBytes(FriendlyByteBuf buf) {
        if (!buf.readBoolean()) {
            this.name = buf.m_130136_(17);
            this.users = new ArrayList<SettingsUser>();
            int usersCount = buf.readInt();
            for (int i = 0; i < usersCount; ++i) {
                SettingsUser user = new SettingsUser();
                user.fromBytes(buf);
                this.users.add(user);
            }
        }
        this.actions.clear();
        for (FrontierSettings.Action action : FrontierSettings.Action.valuesArray) {
            if (!buf.readBoolean()) continue;
            this.actions.add(action);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.special);
        if (!this.special) {
            buf.m_130072_(this.name, 17);
            buf.writeInt(this.users.size());
            for (SettingsUser user : this.users) {
                user.toBytes(buf);
            }
        }
        for (FrontierSettings.Action action : FrontierSettings.Action.valuesArray) {
            buf.writeBoolean(this.actions.contains((Object)action));
        }
    }
}

