/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.settings;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsGroup;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class FrontierSettings {
    private final SettingsGroup OPs = new SettingsGroup("OPs", true);
    private final SettingsGroup owners = new SettingsGroup("Owner", true);
    private final SettingsGroup everyone = new SettingsGroup("Everyone", true);
    private List<SettingsGroup> customGroups = new ArrayList<SettingsGroup>();
    private int changeCounter = 1;
    private static final int dataVersion = 4;

    public void resetToDefault() {
        this.OPs.addAction(Action.CreateGlobalFrontier);
        this.OPs.addAction(Action.DeleteGlobalFrontier);
        this.OPs.addAction(Action.UpdateGlobalFrontier);
        this.OPs.addAction(Action.UpdateSettings);
        this.owners.addAction(Action.DeleteGlobalFrontier);
        this.owners.addAction(Action.UpdateGlobalFrontier);
        this.everyone.addAction(Action.SharePersonalFrontier);
    }

    public SettingsGroup getOPsGroup() {
        return this.OPs;
    }

    public SettingsGroup getOwnersGroup() {
        return this.owners;
    }

    public SettingsGroup getEveryoneGroup() {
        return this.everyone;
    }

    public List<SettingsGroup> getCustomGroups() {
        return this.customGroups;
    }

    public SettingsGroup createCustomGroup(String name) {
        SettingsGroup group = new SettingsGroup(name, false);
        this.customGroups.add(group);
        return group;
    }

    public void removeCustomGroup(SettingsGroup group) {
        this.customGroups.remove(group);
    }

    public boolean checkAction(Action action, @Nullable SettingsUser player, boolean isOP, @Nullable SettingsUser owner) {
        if (player == null) {
            return false;
        }
        if (isOP && this.OPs.hasAction(action)) {
            return true;
        }
        if (player.equals(owner) && this.owners.hasAction(action)) {
            return true;
        }
        if (this.everyone.hasAction(action)) {
            return true;
        }
        for (SettingsGroup group : this.customGroups) {
            if (!group.hasAction(action) || !group.hasUser(player)) continue;
            return true;
        }
        return false;
    }

    public SettingsProfile getProfile(ServerPlayer player) {
        SettingsProfile profile = new SettingsProfile();
        SettingsUser user = new SettingsUser((Player)player);
        for (Action action : this.owners.getActions()) {
            profile.setAction(action, SettingsProfile.State.Owner);
        }
        if (MapFrontiers.isOPorHost(player)) {
            for (Action action : this.OPs.getActions()) {
                profile.setAction(action, SettingsProfile.State.Enabled);
            }
        }
        for (Action action : this.everyone.getActions()) {
            profile.setAction(action, SettingsProfile.State.Enabled);
        }
        if (profile.isAllEnabled()) {
            return profile;
        }
        for (SettingsGroup group : this.customGroups) {
            if (!group.hasUser(user)) continue;
            for (Action action : group.getActions()) {
                profile.setAction(action, SettingsProfile.State.Enabled);
            }
        }
        return profile;
    }

    public void readFromNBT(CompoundTag nbt) {
        int version = nbt.m_128451_("Version");
        if (version == 0) {
            MapFrontiers.LOGGER.warn("Data version in settings not found, expected 4");
        } else if (version < 3) {
            MapFrontiers.LOGGER.warn("Data version in settings lower than expected. The mod uses 4");
        } else if (version > 4) {
            MapFrontiers.LOGGER.warn("Data version in settings higher than expected. The mod uses 4");
        }
        CompoundTag OPsTag = nbt.m_128469_("OPs");
        this.OPs.readFromNBT(OPsTag, version);
        CompoundTag ownersTag = nbt.m_128469_("Owners");
        this.owners.readFromNBT(ownersTag, version);
        CompoundTag everyoneTag = nbt.m_128469_("Everyone");
        this.everyone.readFromNBT(everyoneTag, version);
        this.customGroups.clear();
        ListTag customGroupsTagList = nbt.m_128437_("customGroups", 10);
        for (int i = 0; i < customGroupsTagList.size(); ++i) {
            SettingsGroup group = new SettingsGroup();
            CompoundTag groupTag = customGroupsTagList.m_128728_(i);
            group.readFromNBT(groupTag, version);
            this.customGroups.add(group);
        }
        this.ensureUpdateSettingsAction();
    }

    public void writeToNBT(CompoundTag nbt) {
        CompoundTag OPsTag = new CompoundTag();
        this.OPs.writeToNBT(OPsTag);
        nbt.m_128365_("OPs", (Tag)OPsTag);
        CompoundTag ownersTag = new CompoundTag();
        this.owners.writeToNBT(ownersTag);
        nbt.m_128365_("Owners", (Tag)ownersTag);
        CompoundTag everyoneTag = new CompoundTag();
        this.everyone.writeToNBT(everyoneTag);
        nbt.m_128365_("Everyone", (Tag)everyoneTag);
        ListTag customGroupsTagList = new ListTag();
        for (SettingsGroup group : this.customGroups) {
            CompoundTag groupTag = new CompoundTag();
            group.writeToNBT(groupTag);
            customGroupsTagList.add((Object)groupTag);
        }
        nbt.m_128365_("customGroups", (Tag)customGroupsTagList);
        nbt.m_128405_("Version", 4);
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.OPs.fromBytes(buf);
        this.owners.fromBytes(buf);
        this.everyone.fromBytes(buf);
        this.customGroups = new ArrayList<SettingsGroup>();
        int groupsCount = buf.readInt();
        for (int i = 0; i < groupsCount; ++i) {
            SettingsGroup group = new SettingsGroup();
            group.fromBytes(buf);
            this.customGroups.add(group);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.OPs.toBytes(buf);
        this.owners.toBytes(buf);
        this.everyone.toBytes(buf);
        buf.writeInt(this.customGroups.size());
        for (SettingsGroup group : this.customGroups) {
            group.toBytes(buf);
        }
    }

    public static List<Action> getAvailableActions(String groupName) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!groupName.contentEquals("Owner")) {
            actions.add(Action.CreateGlobalFrontier);
            actions.add(Action.UpdateSettings);
            actions.add(Action.SharePersonalFrontier);
        }
        actions.add(Action.DeleteGlobalFrontier);
        actions.add(Action.UpdateGlobalFrontier);
        return actions;
    }

    public static List<ActionV3> getAvailableActionsV3(String groupName) {
        ArrayList<ActionV3> actions = new ArrayList<ActionV3>();
        if (!groupName.contentEquals("Owner")) {
            actions.add(ActionV3.CreateFrontier);
            actions.add(ActionV3.UpdateSettings);
            actions.add(ActionV3.PersonalFrontier);
        }
        actions.add(ActionV3.DeleteFrontier);
        actions.add(ActionV3.UpdateFrontier);
        return actions;
    }

    public void setChangeCounter(int changeCounter) {
        this.changeCounter = changeCounter;
    }

    public int getChangeCounter() {
        return this.changeCounter;
    }

    public void advanceChangeCounter() {
        ++this.changeCounter;
    }

    private void ensureUpdateSettingsAction() {
        if (this.OPs.hasAction(Action.UpdateSettings) || this.owners.hasAction(Action.UpdateSettings) || this.everyone.hasAction(Action.UpdateSettings)) {
            return;
        }
        for (SettingsGroup group : this.customGroups) {
            if (!group.hasAction(Action.UpdateSettings)) continue;
            return;
        }
        this.OPs.addAction(Action.UpdateSettings);
    }

    public static enum Action {
        CreateGlobalFrontier,
        DeleteGlobalFrontier,
        UpdateGlobalFrontier,
        UpdateSettings,
        SharePersonalFrontier;

        public static final Action[] valuesArray;

        static {
            valuesArray = Action.values();
        }
    }

    public static enum ActionV3 {
        CreateFrontier(Action.CreateGlobalFrontier),
        DeleteFrontier(Action.DeleteGlobalFrontier),
        UpdateFrontier(Action.UpdateGlobalFrontier),
        UpdateSettings(Action.UpdateSettings),
        PersonalFrontier(Action.SharePersonalFrontier);

        private final Action action;

        private ActionV3(Action action) {
            this.action = action;
        }

        public Action toAction() {
            return this.action;
        }
    }
}

