/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class PacketFrontierUpdated {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mapfrontiers", "packet_frontier_updated");
    private final FrontierData frontier;
    private int playerID = -1;

    public PacketFrontierUpdated() {
        this.frontier = new FrontierData();
    }

    public PacketFrontierUpdated(FrontierData frontier) {
        this.frontier = frontier;
    }

    public PacketFrontierUpdated(FrontierData frontier, int playerID) {
        this.frontier = frontier;
        this.playerID = playerID;
    }

    public static PacketFrontierUpdated decode(FriendlyByteBuf buf) {
        PacketFrontierUpdated packet = new PacketFrontierUpdated();
        packet.frontier.fromBytes(buf);
        packet.playerID = buf.readInt();
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        this.frontier.toBytes(buf);
        buf.writeInt(this.playerID);
    }

    public static void handle(PacketContext<PacketFrontierUpdated> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            PacketFrontierUpdated message = (PacketFrontierUpdated)ctx.message();
            FrontierOverlay frontierOverlay = MapFrontiersClient.getFrontiersOverlayManager(message.frontier.getPersonal()).updateFrontier(message.frontier);
            if (frontierOverlay != null) {
                ClientEventHandler.postUpdatedFrontierEvent(frontierOverlay, message.playerID);
            }
        }
    }
}

