/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ModSettings;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class PacketFrontierSettings {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mapfrontiers", "packet_frontier_settings");
    private final FrontierSettings settings;

    public PacketFrontierSettings() {
        this.settings = new FrontierSettings();
    }

    public PacketFrontierSettings(FrontierSettings settings) {
        this.settings = settings;
    }

    public static PacketFrontierSettings decode(FriendlyByteBuf buf) {
        PacketFrontierSettings packet = new PacketFrontierSettings();
        packet.settings.fromBytes(buf);
        packet.settings.setChangeCounter(buf.readInt());
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        this.settings.toBytes(buf);
        buf.writeInt(this.settings.getChangeCounter());
    }

    public static void handle(PacketContext<PacketFrontierSettings> ctx) {
        PacketFrontierSettings message = (PacketFrontierSettings)ctx.message();
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerPlayer player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.f_8924_;
            if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.UpdateSettings, new SettingsUser((Player)player), MapFrontiers.isOPorHost(player), null)) {
                FrontiersManager.instance.setSettings(message.settings);
                for (ServerPlayer p : server.m_6846_().m_11314_()) {
                    PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(p)), p);
                }
            } else {
                PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
            }
        } else if (Side.CLIENT.equals((Object)ctx.side()) && Minecraft.m_91087_().f_91080_ instanceof ModSettings) {
            ((ModSettings)Minecraft.m_91087_().f_91080_).setFrontierSettings(message.settings);
        }
    }
}

