/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ShapeChunkButtons;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ShapeVertexButtons;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Context;
import journeymap.client.api.util.UIState;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

@ParametersAreNonnullByDefault
public class NewFrontier
extends Screen {
    private final IClientAPI jmAPI;
    private float scaleFactor;
    private int actualWidth;
    private int actualHeight;
    private OptionButton buttonFrontierType;
    private OptionButton buttonFrontierMode;
    private OptionButton buttonAfterCreate;
    private ShapeVertexButtons shapeVertexButtons;
    private ShapeChunkButtons shapeChunkButtons;
    private SimpleLabel labelSize;
    private TextBoxInt textSize;
    private SimpleButton buttonCreateFrontier;
    private SimpleButton buttonCancel;
    private final List<SimpleLabel> labels;

    public NewFrontier(IClientAPI jmAPI) {
        super((Component)Component.m_237115_((String)"mapfrontiers.title_new_frontier"));
        this.jmAPI = jmAPI;
        this.labels = new ArrayList<SimpleLabel>();
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            Services.PLATFORM.popGuiLayer();
            Services.PLATFORM.pushGuiLayer(new NewFrontier(jmAPI));
        });
    }

    public void m_7856_() {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.f_96541_, this, 338, 338);
        this.actualWidth = (int)((float)this.f_96543_ * this.scaleFactor);
        this.actualHeight = (int)((float)this.f_96544_ * this.scaleFactor);
        this.labels.clear();
        this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 130, this.actualHeight / 2 - 112, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.frontier_type"), -2236963));
        this.buttonFrontierType = new OptionButton(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 - 114, 130, this::buttonPressed);
        this.buttonFrontierType.addOption(Config.getTranslatedEnum(Config.FilterFrontierType.Global));
        this.buttonFrontierType.addOption(Config.getTranslatedEnum(Config.FilterFrontierType.Personal));
        this.buttonFrontierType.setSelected(0);
        if (!MapFrontiersClient.isModOnServer() || MapFrontiersClient.getSettingsProfile().createFrontier != SettingsProfile.State.Enabled) {
            this.buttonFrontierType.setSelected(1);
            this.buttonFrontierType.f_93623_ = false;
        }
        this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 130, this.actualHeight / 2 - 96, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.frontier_mode"), -2236963));
        this.buttonFrontierMode = new OptionButton(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 - 98, 130, this::buttonPressed);
        this.buttonFrontierMode.addOption(Config.getTranslatedEnum(FrontierData.Mode.Vertex));
        this.buttonFrontierMode.addOption(Config.getTranslatedEnum(FrontierData.Mode.Chunk));
        this.buttonFrontierMode.setSelected(Config.newFrontierMode.ordinal());
        this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 130, this.actualHeight / 2 - 80, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.after_creating"), -2236963));
        this.buttonAfterCreate = new OptionButton(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 - 82, 130, this::buttonPressed);
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Info));
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Edit));
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Nothing));
        this.buttonAfterCreate.setSelected(Config.afterCreatingFrontier.ordinal());
        this.shapeVertexButtons = new ShapeVertexButtons(this.f_96547_, this.actualWidth / 2 - 162, this.actualHeight / 2 - 52, Config.newFrontierShape, s -> this.shapeButtonsUpdated());
        this.shapeChunkButtons = new ShapeChunkButtons(this.f_96547_, this.actualWidth / 2 - 107, this.actualHeight / 2 - 52, Config.newFrontierChunkShape, s -> this.shapeButtonsUpdated());
        this.labelSize = new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 80, this.actualHeight / 2 + 90, SimpleLabel.Align.Left, (Component)Component.m_237113_((String)""), -1);
        this.labels.add(this.labelSize);
        this.textSize = new TextBoxInt(1, 1, 999, this.f_96547_, this.actualWidth / 2 + 16, this.actualHeight / 2 + 88, 64);
        this.textSize.setValueChangedCallback(value -> {
            if (Config.newFrontierMode == FrontierData.Mode.Vertex) {
                if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
                    if (Config.isInRange("newFrontierShapeWidth", value)) {
                        Config.newFrontierShapeWidth = value;
                    }
                } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius && Config.isInRange("newFrontierShapeRadius", value)) {
                    Config.newFrontierShapeRadius = value;
                }
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Width) {
                if (Config.isInRange("newFrontierChunkShapeWidth", value)) {
                    Config.newFrontierChunkShapeWidth = value;
                    this.shapeChunkButtons.setSize(value);
                }
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Length && Config.isInRange("newFrontierChunkShapeLength", value)) {
                Config.newFrontierChunkShapeLength = value;
                this.shapeChunkButtons.setSize(value);
            }
        });
        this.buttonCreateFrontier = new SimpleButton(this.f_96547_, this.actualWidth / 2 - 110, this.actualHeight / 2 + 146, 100, (Component)Component.m_237115_((String)"mapfrontiers.create"), this::buttonPressed);
        this.buttonCancel = new SimpleButton(this.f_96547_, this.actualWidth / 2 + 10, this.actualHeight / 2 + 146, 100, (Component)Component.m_237115_((String)"gui.cancel"), this::buttonPressed);
        this.m_142416_((GuiEventListener)this.buttonFrontierType);
        this.m_142416_((GuiEventListener)this.buttonFrontierMode);
        this.m_142416_((GuiEventListener)this.buttonAfterCreate);
        this.m_142416_((GuiEventListener)this.shapeVertexButtons);
        this.m_142416_((GuiEventListener)this.shapeChunkButtons);
        this.m_142416_((GuiEventListener)this.textSize);
        this.m_142416_((GuiEventListener)this.buttonCreateFrontier);
        this.m_142416_((GuiEventListener)this.buttonCancel);
        this.shapeButtonsUpdated();
    }

    public void m_86600_() {
        this.textSize.m_94120_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.actualWidth / 2, 8, -1);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        for (SimpleLabel label : this.labels) {
            if (!label.f_93624_) continue;
            label.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85849_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        if (mouseButton == 0) {
            this.textSize.m_6375_(mouseX, mouseY, mouseButton);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.m_7979_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    protected void buttonPressed(Button button) {
        if (button == this.buttonFrontierMode) {
            Config.newFrontierMode = FrontierData.Mode.values()[this.buttonFrontierMode.getSelected()];
            this.shapeButtonsUpdated();
        } else if (button == this.buttonAfterCreate) {
            Config.afterCreatingFrontier = Config.AfterCreatingFrontier.values()[this.buttonAfterCreate.getSelected()];
        } else if (button == this.buttonCreateFrontier) {
            boolean personal = this.buttonFrontierType.getSelected() == 1;
            Services.PLATFORM.popGuiLayer();
            UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
            if (uiState != null) {
                MapFrontiersClient.getFrontiersOverlayManager(personal).clientCreateNewfrontier((ResourceKey<Level>)uiState.dimension, this.calculateVertices(), this.calculateChunks());
            }
        } else if (button == this.buttonCancel) {
            Services.PLATFORM.popGuiLayer();
        }
    }

    public void m_7861_() {
        ClientEventHandler.unsuscribeAllEvents((Object)this);
        ClientEventHandler.postUpdatedConfigEvent();
    }

    private void shapeButtonsUpdated() {
        if (Config.newFrontierMode == FrontierData.Mode.Vertex) {
            int selected;
            this.shapeVertexButtons.f_93624_ = true;
            this.shapeChunkButtons.f_93624_ = false;
            Config.newFrontierShape = selected = this.shapeVertexButtons.getSelected();
            if (selected == 0 || selected == 1) {
                this.labelSize.f_93624_ = false;
                this.textSize.f_93624_ = false;
                return;
            }
            this.labelSize.f_93624_ = true;
            this.textSize.f_93624_ = true;
            if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
                this.labelSize.setText((Component)Component.m_237115_((String)"mapfrontiers.shape_width"));
                this.textSize.m_94144_(String.valueOf(Config.newFrontierShapeWidth));
            } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius) {
                this.labelSize.setText((Component)Component.m_237115_((String)"mapfrontiers.shape_radius"));
                this.textSize.m_94144_(String.valueOf(Config.newFrontierShapeRadius));
            }
        } else {
            int selected;
            this.shapeVertexButtons.f_93624_ = false;
            this.shapeChunkButtons.f_93624_ = true;
            Config.newFrontierChunkShape = selected = this.shapeChunkButtons.getSelected();
            if (selected == 0 || selected == 1 || selected == 7) {
                this.labelSize.f_93624_ = false;
                this.textSize.f_93624_ = false;
                return;
            }
            this.labelSize.f_93624_ = true;
            this.textSize.f_93624_ = true;
            if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Width) {
                this.labelSize.setText((Component)Component.m_237115_((String)"mapfrontiers.shape_width"));
                this.textSize.m_94144_(String.valueOf(Config.newFrontierChunkShapeWidth));
                this.shapeChunkButtons.setSize(Config.newFrontierChunkShapeWidth);
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Length) {
                this.labelSize.setText((Component)Component.m_237115_((String)"mapfrontiers.shape_length"));
                this.textSize.m_94144_(String.valueOf(Config.newFrontierChunkShapeLength));
                this.shapeChunkButtons.setSize(Config.newFrontierChunkShapeLength);
            }
        }
    }

    private List<BlockPos> calculateVertices() {
        if (this.f_96541_.f_91074_ == null || Config.newFrontierMode != FrontierData.Mode.Vertex) {
            return null;
        }
        List<Vec2> shapeVertices = this.shapeVertexButtons.getVertices();
        if (shapeVertices == null) {
            return new ArrayList<BlockPos>();
        }
        double radius = 0.0;
        if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
            radius = Config.newFrontierShapeWidth;
            if (radius < 2.0) {
                radius = 2.0;
            }
            if (shapeVertices.size() == 3) {
                radius = radius * Math.sqrt(3.0) / 3.0;
            } else if (shapeVertices.size() == 4) {
                radius = Math.sqrt(radius * radius * 2.0) / 2.0;
            }
        } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius && (radius = (double)Config.newFrontierShapeRadius) < 1.0) {
            radius = 1.0;
        }
        LinkedHashSet<BlockPos> polygonVertices = new LinkedHashSet<BlockPos>();
        BlockPos playerPos = this.f_96541_.f_91074_.m_20183_();
        for (Vec2 vertex : shapeVertices) {
            int x = (int)Math.round((double)vertex.f_82470_ * radius) + playerPos.m_123341_();
            int z = (int)Math.round((double)vertex.f_82471_ * radius) + playerPos.m_123343_();
            polygonVertices.add(new BlockPos(x, 70, z));
        }
        return new ArrayList<BlockPos>(polygonVertices);
    }

    private List<ChunkPos> calculateChunks() {
        ArrayList<ChunkPos> chunks;
        block11: {
            int selected;
            ChunkPos playerChunk;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    if (this.f_96541_.f_91074_ == null || Config.newFrontierMode != FrontierData.Mode.Chunk) {
                                        return null;
                                    }
                                    chunks = new ArrayList<ChunkPos>();
                                    playerChunk = new ChunkPos(this.f_96541_.f_91074_.m_20183_());
                                    selected = this.shapeChunkButtons.getSelected();
                                    if (selected != 1) break block10;
                                    chunks.add(playerChunk);
                                    break block11;
                                }
                                if (selected != 2) break block12;
                                int shapeWidth = Config.newFrontierChunkShapeWidth;
                                ChunkPos start = new ChunkPos(playerChunk.f_45578_ - shapeWidth / 2, playerChunk.f_45579_ - shapeWidth / 2);
                                for (int i = 0; i < shapeWidth * shapeWidth; ++i) {
                                    chunks.add(new ChunkPos(start.f_45578_ + i % shapeWidth, start.f_45579_ + i / shapeWidth));
                                }
                                break block11;
                            }
                            if (selected != 3) break block13;
                            int shapeWidth = Config.newFrontierChunkShapeWidth;
                            ChunkPos start = new ChunkPos(playerChunk.f_45578_ - shapeWidth / 2, playerChunk.f_45579_ - shapeWidth / 2);
                            for (int i = 0; i < shapeWidth * shapeWidth; ++i) {
                                if (i >= shapeWidth && i < shapeWidth * (shapeWidth - 1) && i % shapeWidth != 0 && i % shapeWidth != shapeWidth - 1) continue;
                                chunks.add(new ChunkPos(start.f_45578_ + i % shapeWidth, start.f_45579_ + i / shapeWidth));
                            }
                            break block11;
                        }
                        if (selected != 4) break block14;
                        int shapeWidth = Config.newFrontierChunkShapeWidth;
                        ChunkPos start = new ChunkPos(playerChunk.f_45578_ - shapeWidth / 2, playerChunk.f_45579_ - shapeWidth / 2);
                        for (int z = start.f_45579_; z < start.f_45579_ + shapeWidth; ++z) {
                            for (int x = start.f_45578_; x < start.f_45578_ + shapeWidth; ++x) {
                                int deltaX = x - playerChunk.f_45578_;
                                int deltaZ = z - playerChunk.f_45579_;
                                if (shapeWidth % 2 == 0) {
                                    deltaX += deltaX < 0 ? 1 : 0;
                                    deltaZ += deltaZ < 0 ? 1 : 0;
                                }
                                if (Math.abs(deltaX) + Math.abs(deltaZ) > (shapeWidth - 1) / 2) continue;
                                chunks.add(new ChunkPos(x, z));
                            }
                        }
                        break block11;
                    }
                    if (selected != 5) break block15;
                    int shapeLength = Config.newFrontierChunkShapeLength;
                    int start = playerChunk.f_45578_ - shapeLength / 2;
                    for (int i = 0; i < shapeLength; ++i) {
                        chunks.add(new ChunkPos(start + i, playerChunk.f_45579_));
                    }
                    break block11;
                }
                if (selected != 6) break block16;
                int shapeLength = Config.newFrontierChunkShapeLength;
                int start = playerChunk.f_45579_ - shapeLength / 2;
                for (int i = 0; i < shapeLength; ++i) {
                    chunks.add(new ChunkPos(playerChunk.f_45578_, start + i));
                }
                break block11;
            }
            if (selected != 7) break block11;
            ChunkPos start = new ChunkPos(Math.floorDiv(playerChunk.f_45578_, 32) * 32, Math.floorDiv(playerChunk.f_45579_, 32) * 32);
            for (int z = 0; z < 32; ++z) {
                for (int x = 0; x < 32; ++x) {
                    chunks.add(new ChunkPos(start.f_45578_ + x, start.f_45579_ + z));
                }
            }
        }
        return chunks;
    }
}

