/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import java.util.function.DoubleConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class TextBoxDouble
extends EditBox {
    private final double defaultValue;
    private final double min;
    private final double max;
    private DoubleConsumer valueChangedCallback;

    public TextBoxDouble(double defaultValue, double min, double max, Font font, int x, int y, int width) {
        super(font, x, y, width, 12, (Component)Component.m_237119_());
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.setValue(defaultValue);
    }

    public void setValueChangedCallback(DoubleConsumer callback) {
        this.valueChangedCallback = callback;
    }

    public void m_94164_(String textToWrite) {
        if (textToWrite.equals("-") && this.m_94207_() == 0) {
            super.m_94164_(textToWrite);
            return;
        }
        if (textToWrite.equals("0")) {
            super.m_94164_(textToWrite);
            return;
        }
        if (textToWrite.equals(".")) {
            super.m_94164_(textToWrite);
            return;
        }
        String currentString = this.m_94155_();
        super.m_94164_(textToWrite);
        try {
            double current = Double.parseDouble(this.m_94155_());
            this.setValue(current);
        }
        catch (Exception e) {
            this.m_94144_(currentString);
        }
    }

    public void setValue(Object object) {
        this.m_94144_(object.toString());
        if (this.valueChangedCallback != null) {
            try {
                double current = Double.parseDouble(this.m_94155_());
                this.valueChangedCallback.accept(current);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_5534_(char c, int key) {
        boolean res = false;
        if (this.m_198029_() && (res = super.m_5534_(c, key))) {
            double current;
            try {
                current = Double.parseDouble(this.m_94155_());
                if (current > this.max) {
                    this.setValue(this.max);
                    current = this.max;
                }
            }
            catch (Exception e) {
                boolean bl = true;
                return bl;
            }
            finally {
                this.m_94198_();
                this.m_94201_();
            }
            if (this.valueChangedCallback != null) {
                this.valueChangedCallback.accept(Math.max(current, this.min));
            }
        }
        return res;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean res = false;
        if (this.m_198029_()) {
            res = super.m_7933_(keyCode, scanCode, modifiers);
            if (this.valueChangedCallback != null && (keyCode == 259 || keyCode == 261)) {
                this.valueChangedCallback.accept(this.clamped());
            }
            if (keyCode == 257 || keyCode == 335) {
                this.m_93692_(false);
            }
        }
        return res;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.f_93624_ && this.f_93622_) {
            double current;
            try {
                current = Double.parseDouble(this.m_94155_());
            }
            catch (Exception e) {
                current = this.defaultValue;
            }
            if (delta > 0.0) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.setValue(Math.min(current + 0.1, this.max));
            } else if (delta < 0.0) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.setValue(Math.max(current - 0.1, this.min));
            }
            return true;
        }
        return false;
    }

    public double clamped() {
        double current;
        String text = this.m_94155_();
        if (text.length() == 0) {
            return this.defaultValue;
        }
        try {
            current = Double.parseDouble(text);
        }
        catch (Exception e) {
            return this.defaultValue;
        }
        current = Math.max(this.min, current);
        current = Math.min(this.max, current);
        return current;
    }

    public void m_93692_(boolean isFocusedIn) {
        if (!isFocusedIn) {
            this.setValue(this.clamped());
        }
        super.m_93692_(isFocusedIn);
    }
}

