/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class ScrollBox
extends AbstractWidgetNoNarration {
    private final int elementHeight;
    private int scrollStart = 0;
    private final int scrollHeight;
    private int scrollBarPos = 0;
    private int scrollBarHeight = 0;
    private boolean scrollBarHovered = false;
    private boolean scrollBarGrabbed = false;
    private int scrollBarGrabbedYPos = 0;
    private final List<ScrollElement> elements = new ArrayList<ScrollElement>();
    private int selected = -1;
    private Consumer<ScrollElement> elementClickedCallback;
    private Consumer<ScrollElement> elementDeletedCallback;

    public ScrollBox(int x, int y, int width, int height, int elementHeight) {
        super(x, y, width, Math.max(height, elementHeight), (Component)Component.m_237119_());
        this.elementHeight = elementHeight;
        this.scrollHeight = this.f_93619_ / elementHeight;
        this.f_93619_ = this.scrollHeight * elementHeight;
    }

    public void setElementClickedCallback(Consumer<ScrollElement> callback) {
        this.elementClickedCallback = callback;
    }

    public void setElementDeletedCallback(Consumer<ScrollElement> callback) {
        this.elementDeletedCallback = callback;
    }

    public List<ScrollElement> getElements() {
        return this.elements;
    }

    public void addElement(ScrollElement element) {
        element.setX(this.m_252754_());
        element.setY(this.m_252907_() + this.elements.size() * this.elementHeight);
        this.elements.add(element);
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public void selectElement(ScrollElement element) {
        this.selected = this.elements.indexOf(element);
    }

    public ScrollElement getSelectedElement() {
        if (this.selected >= 0 && this.selected < this.elements.size()) {
            return this.elements.get(this.selected);
        }
        return null;
    }

    public void selectIndex(int index) {
        this.selected = Math.min(Math.max(index, -1), this.elements.size() - 1);
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void selectElementIf(Predicate<ScrollElement> pred) {
        ScrollElement element = this.elements.stream().filter(pred).findFirst().orElse(null);
        if (element == null) {
            this.selected = -1;
        } else {
            this.selectElement(element);
        }
    }

    public void removeElement(ScrollElement element) {
        ListIterator<ScrollElement> it = this.elements.listIterator();
        while (it.hasNext()) {
            if (it.next() != element) continue;
            this.removeElement(element, it);
            return;
        }
    }

    private void removeElement(ScrollElement element, ListIterator<ScrollElement> it) {
        element.delete();
        it.remove();
        if (this.selected == this.elements.size()) {
            this.selected = this.elements.size() - 1;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).setY(this.m_252907_() + i * this.elementHeight);
        }
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
        if (this.elementDeletedCallback != null) {
            this.elementDeletedCallback.accept(element);
        }
    }

    public void removeAll() {
        for (ScrollElement element : this.elements) {
            element.delete();
        }
        this.elements.clear();
        this.selected = -1;
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.f_93624_ && (this.f_93622_ || this.scrollBarHovered) && !this.scrollBarGrabbed) {
            int amount = (int)(-delta);
            if (amount < 0 && this.scrollStart == 0) {
                return false;
            }
            if (amount > 0 && this.scrollStart + this.scrollHeight >= this.elements.size()) {
                return false;
            }
            this.scrollStart += amount;
            this.updateScrollWindow();
            this.updateScrollBar();
            return true;
        }
        return false;
    }

    public void scrollBottom() {
        this.scrollStart = this.elements.size() - this.scrollHeight;
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).render(graphics, mouseX, mouseY, partialTicks, this.selected == i);
        }
        if (this.scrollBarHeight > 0) {
            this.scrollBarHovered = mouseX >= this.m_252754_() + this.f_93618_ + 5 && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ + 15 && mouseY < this.m_252907_() + this.f_93619_;
            int barColor = -8947849;
            if (this.scrollBarGrabbed) {
                barColor = -10066330;
            } else if (this.scrollBarHovered) {
                barColor = -5592406;
            }
            graphics.m_280509_(this.m_252754_() + this.f_93618_ + 5, this.m_252907_(), this.m_252754_() + this.f_93618_ + 15, this.m_252907_() + this.f_93619_, 0x1AFFFFFF);
            graphics.m_280509_(this.m_252754_() + this.f_93618_ + 5, this.m_252907_() + this.scrollBarPos, this.m_252754_() + this.f_93618_ + 15, this.m_252907_() + this.scrollBarPos + this.scrollBarHeight, barColor);
        }
    }

    public boolean m_93680_(double mouseX, double mouseY) {
        if (this.f_93624_) {
            if (this.scrollBarHeight > 0 && mouseX >= (double)(this.m_252754_() + this.f_93618_ + 5) && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + this.f_93618_ + 15) && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
                if (mouseY < (double)(this.m_252907_() + this.scrollBarPos)) {
                    this.m_6050_(mouseX, mouseY, 1.0);
                } else if (mouseY > (double)(this.m_252907_() + this.scrollBarPos + this.scrollBarHeight)) {
                    this.m_6050_(mouseX, mouseY, -1.0);
                } else {
                    this.scrollBarGrabbed = true;
                    this.scrollBarGrabbedYPos = (int)mouseY - this.m_252907_() - this.scrollBarPos;
                }
                return true;
            }
            if (this.f_93622_ && !this.scrollBarGrabbed) {
                ListIterator<ScrollElement> it = this.elements.listIterator();
                while (it.hasNext()) {
                    ScrollElement element = it.next();
                    ScrollElement.Action action = element.mousePressed(mouseX, mouseY);
                    if (action == ScrollElement.Action.Deleted) {
                        this.removeElement(element, it);
                        return true;
                    }
                    if (action != ScrollElement.Action.Clicked) continue;
                    this.selectElement(element);
                    if (this.elementClickedCallback != null) {
                        this.elementClickedCallback.accept(element);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void mouseReleased() {
        if (this.f_93624_ && this.scrollBarHeight > 0 && this.scrollBarGrabbed) {
            this.scrollBarGrabbed = false;
            this.updateScrollBar();
        }
    }

    public void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.scrollBarHeight > 0 && this.scrollBarGrabbed) {
            int delta = (int)mouseY - this.m_252907_() - this.scrollBarPos - this.scrollBarGrabbedYPos;
            if (delta == 0) {
                return;
            }
            this.scrollBarPos += delta;
            if (this.scrollBarPos < 0) {
                this.scrollBarPos = 0;
            } else if (this.scrollBarPos + this.scrollBarHeight > this.f_93619_) {
                this.scrollBarPos = this.f_93619_ - this.scrollBarHeight;
            }
            int newScrollStart = Math.round((float)this.scrollBarPos / (float)this.f_93619_ * (float)this.elements.size());
            if (newScrollStart != this.scrollStart) {
                this.scrollStart = newScrollStart;
                this.updateScrollWindow();
            }
        }
    }

    private void updateScrollWindow() {
        if (this.elements.size() <= this.scrollHeight) {
            this.scrollStart = 0;
        } else {
            int bottomExtra = this.elements.size() - (this.scrollStart + this.scrollHeight);
            if (bottomExtra < 0) {
                this.scrollStart += bottomExtra;
            }
            if (this.scrollStart < 0) {
                this.scrollStart = 0;
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i < this.scrollStart || i >= this.scrollStart + this.scrollHeight) {
                this.elements.get((int)i).visible = false;
                continue;
            }
            this.elements.get((int)i).visible = true;
            this.elements.get(i).setY(this.m_252907_() + (i - this.scrollStart) * this.elementHeight);
        }
    }

    private void updateScrollBar() {
        if (this.elements.size() <= this.scrollHeight) {
            this.scrollBarHeight = 0;
            this.scrollBarHovered = false;
            this.scrollBarGrabbed = false;
            return;
        }
        this.scrollBarHeight = Math.round((float)this.scrollHeight / (float)this.elements.size() * (float)this.f_93619_);
        this.scrollBarPos = Math.round((float)this.scrollStart / (float)this.elements.size() * (float)this.f_93619_);
        if (this.scrollBarPos + this.scrollBarHeight > this.f_93619_) {
            this.scrollBarPos = this.f_93619_ - this.scrollBarHeight;
        }
    }

    public static class ScrollElement {
        public boolean visible = true;
        protected int x = 0;
        protected int y = 0;
        protected boolean isHovered = false;
        protected final int height;
        protected final int width;

        public ScrollElement(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public void delete() {
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
            if (this.visible) {
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                this.renderWidget(graphics, mouseX, mouseY, partialTicks, selected);
            } else {
                this.isHovered = false;
            }
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
        }

        public Action mousePressed(double mouseX, double mouseY) {
            return Action.None;
        }

        static enum Action {
            None,
            Clicked,
            Deleted;

        }
    }
}

