/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class TabbedBox
extends AbstractWidgetNoNarration {
    private final Font font;
    private final IntConsumer tabChanged;
    private final int width;
    private final int height;
    private final List<Tab> tabs;
    private int selected;

    public TabbedBox(Font font, int x, int y, int width, int height, IntConsumer tabChanged) {
        super(x, y, width, 16, (Component)Component.m_237119_());
        this.font = font;
        this.tabChanged = tabChanged;
        this.tabs = new ArrayList<Tab>();
        this.selected = -1;
        this.width = width;
        this.height = height;
    }

    public void addTab(Component text, boolean enabled) {
        this.tabs.add(new Tab(this.font, text, enabled));
        this.updateTabPositions();
        if (this.selected == -1) {
            this.selected = 0;
        }
    }

    public void setTabSelected(int tab) {
        this.selected = tab;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabs.get(i).render(graphics, mouseX, mouseY, partialTicks, i == this.selected);
        }
        if (this.selected == -1) {
            graphics.m_280656_(this.m_252754_(), this.m_252754_() + this.width, this.m_252907_() + 16, -8947849);
        } else {
            int selectedX = this.tabs.get((int)this.selected).x;
            graphics.m_280656_(this.m_252754_(), selectedX, this.m_252907_() + 16, -8947849);
            graphics.m_280656_(selectedX + 70, this.m_252754_() + this.width, this.m_252907_() + 16, -8947849);
        }
        graphics.m_280656_(this.m_252754_(), this.m_252754_() + this.width, this.m_252907_() + this.height, -8947849);
        graphics.m_280315_(this.m_252754_(), this.m_252907_() + 16, this.m_252907_() + this.height, -8947849);
        graphics.m_280315_(this.m_252754_() + this.width, this.m_252907_() + 16, this.m_252907_() + this.height, -8947849);
    }

    public boolean m_93680_(double mouseX, double mouseY) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.tabs.get(i).clicked() || this.selected == i) continue;
            this.selected = i;
            if (this.tabChanged != null) {
                this.tabChanged.accept(this.selected);
            }
            return true;
        }
        return false;
    }

    private void updateTabPositions() {
        int tabX = this.m_252754_() + this.width / 2 - this.tabs.size() * 35;
        for (Tab tab : this.tabs) {
            tab.x = tabX;
            tab.y = this.m_252907_();
            tabX += 70;
        }
    }

    private static class Tab {
        private int x = 0;
        private int y = 0;
        private boolean isHovered = false;
        private final boolean active;
        private final SimpleLabel label;

        public Tab(Font font, Component text, boolean active) {
            this.active = active;
            this.label = new SimpleLabel(font, 0, 0, SimpleLabel.Align.Center, text, -8947849);
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
            this.isHovered = this.active ? mouseX >= this.x && mouseY >= this.y && mouseX < this.x + 71 && mouseY < this.y + 16 : false;
            graphics.m_280656_(this.x, this.x + 70, this.y, -8947849);
            graphics.m_280315_(this.x, this.y, this.y + 16, -8947849);
            graphics.m_280315_(this.x + 70, this.y, this.y + 16, -8947849);
            if (this.active) {
                if (selected || this.isHovered) {
                    this.label.setColor(-1);
                } else {
                    this.label.setColor(-8947849);
                }
            } else {
                this.label.setColor(-12303292);
            }
            this.label.m_252865_(this.x + 35);
            this.label.m_253211_(this.y + 5);
            this.label.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        public boolean clicked() {
            return this.isHovered;
        }
    }
}

