/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import com.mojang.blaze3d.platform.InputConstants;
import games.alejandrocoria.mapfrontiers.MapFrontiersForge;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.Config;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.display.ThemeButtonDisplay;
import journeymap.client.api.event.forge.FullscreenDisplayEvent;
import journeymap.client.api.event.forge.PopupMenuEvent;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="mapfrontiers")
public class MapFrontiersClientForge
extends MapFrontiersClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        MapFrontiersClientForge.init();
        MapFrontiersForge.LOGGER.info("Forge clientSetup done");
    }

    @SubscribeEvent
    public static void livingUpdateEvent(LivingEvent.LivingTickEvent event) {
        Minecraft client = Minecraft.m_91087_();
        if (event.getEntity() == client.f_91074_) {
            Player player = (Player)event.getEntity();
            ClientEventHandler.postPlayerTickEvent(client, player);
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientEventHandler.postClientTickEvent(Minecraft.m_91087_());
        }
    }

    @SubscribeEvent
    public static void RenderGameOverlayEvent(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.POTION_ICONS.id())) {
            ClientEventHandler.postHudRenderEvent(event.getGuiGraphics(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void clientConnectedToServer(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientEventHandler.postClientConnectedEvent();
    }

    @SubscribeEvent
    public static void clientDisconnectionFromServer(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientEventHandler.postClientDisconnectedEvent();
    }

    @SubscribeEvent
    public static void mouseEvent(InputEvent.MouseButton event) {
        if (event.getAction() == 0) {
            ClientEventHandler.postMouseReleaseEvent(event.getButton());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFullscreenAddonButton(FullscreenDisplayEvent.AddonButtonDisplayEvent event) {
        ThemeButtonDisplay buttonDisplay = event.getThemeButtonDisplay();
        ClientEventHandler.postAddonButtonDisplayEvent(buttonDisplay);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFullscreenpopupMenu(PopupMenuEvent.FullscreenPopupMenuEvent event) {
        ModPopupMenu popupMenu = event.getPopupMenu();
        ClientEventHandler.postFullscreenPopupMenuEvent(popupMenu);
    }

    @Mod.EventBusSubscriber(modid="mapfrontiers", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ConfigEventHandler {
        @SubscribeEvent
        public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
            if (configEvent.getConfig().getModId().equals("mapfrontiers") && configEvent.getConfig().getType() == ModConfig.Type.CLIENT) {
                Config.bakeConfig();
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="mapfrontiers", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class KeyMappingsEventHandler {
        @SubscribeEvent
        public static void registerKeyMappingsEvent(RegisterKeyMappingsEvent event) {
            MapFrontiersClient.openSettingsKey = new KeyMapping("mapfrontiers.key.open_settings", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 297, "mapfrontiers.key.category");
            event.register(MapFrontiersClient.openSettingsKey);
        }
    }
}

