/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.phys;

import java.io.Serializable;
import net.minecraft.nbt.CompoundTag;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.comps.phys.X;
import pro.komaru.tridot.util.comps.phys.Y;
import pro.komaru.tridot.util.comps.phys.Z;
import pro.komaru.tridot.util.math.Interp;

public class Vec3
implements Pos3,
Serializable {
    public float x;
    public float y;
    public float z;

    public Vec3(float x, float y, float z) {
        this.set(x, y, z);
    }

    public Vec3(double x, double y, double z) {
        this.set((float)x, (float)y, (float)z);
    }

    public Vec3(Pos3 pos) {
        this.set(pos);
    }

    public Vec3() {
        this.set(0.0f, 0.0f, 0.0f);
    }

    public static Vec3 from(net.minecraft.world.phys.Vec3 mc) {
        return new Vec3((float)mc.f_82479_, (float)mc.f_82480_, (float)mc.f_82481_);
    }

    public static Vec3 zero() {
        return new Vec3();
    }

    public Vec3 cpy() {
        return new Vec3(this);
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public Vec3 x(float value) {
        this.x = value;
        return this;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public Vec3 y(float value) {
        this.y = value;
        return this;
    }

    @Override
    public float z() {
        return this.z;
    }

    @Override
    public Vec3 z(float value) {
        this.z = value;
        return this;
    }

    public Vec3 add(Pos3 xyz) {
        return this.add((X & Y)xyz);
    }

    public <XYZ extends X & Y> Vec3 add(XYZ xyz) {
        return this.add(xyz, xyz, (Z)xyz);
    }

    public Vec3 add(X x, Y y, Z z) {
        return this.add(x.x(), y.y(), z.z());
    }

    public Vec3 add(float x, float y, float z) {
        this.set(this.x() + x, this.y() + y, this.z() + z);
        return this;
    }

    public Vec3 sub(Pos3 xyz) {
        return this.sub((X & Y)xyz);
    }

    public <XYZ extends X & Y> Vec3 sub(XYZ xyz) {
        return this.sub(xyz, xyz, (Z)xyz);
    }

    public Vec3 sub(X x, Y y, Z z) {
        return this.sub(x.x(), y.y(), z.z());
    }

    public Vec3 sub(float x, float y, float z) {
        return this.add(-x, -y, -z);
    }

    public Vec3 set(Pos3 other) {
        return this.set(other.x(), other.y(), other.z());
    }

    public Vec3 set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public Vec3 scale(float scl) {
        return this.scale(scl, scl, scl);
    }

    public Vec3 scale(Pos3 xyz) {
        return this.scale((X & Y)xyz);
    }

    public <XYZ extends X & Y> Vec3 scale(XYZ xyz) {
        return this.scale(xyz, xyz, (Z)xyz);
    }

    public Vec3 scale(X x, Y y, Z z) {
        return this.scale(x.x(), y.y(), z.z());
    }

    public Vec3 scale(float x, float y, float z) {
        this.set(this.x() * x, this.y() * y, this.z() * z);
        return this;
    }

    public float len2() {
        return this.x() * this.x() + this.y() * this.y() + this.z() * this.z();
    }

    public float len() {
        return (float)Math.sqrt(this.len2());
    }

    public Vec3 nor() {
        return this.scale(1.0f / this.len());
    }

    public net.minecraft.world.phys.Vec3 mcVec() {
        return new net.minecraft.world.phys.Vec3((double)this.x(), (double)this.y(), (double)this.z());
    }

    public CompoundTag toNbtVec() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("x", this.x());
        nbt.m_128350_("y", this.y());
        nbt.m_128350_("z", this.z());
        return nbt;
    }

    public Vec3 fromNbtVec(CompoundTag nbt) {
        return this.set(nbt.m_128457_("x"), nbt.m_128457_("y"), nbt.m_128457_("z"));
    }

    public Vec3 lerp(Pos3 pos, float progress) {
        return this.lerp(pos, progress, Interp.linear);
    }

    public Vec3 lerp(Pos3 pos, float progress, Interp interp) {
        float x = interp.apply(progress, this.x(), pos.x());
        float y = interp.apply(progress, this.y(), pos.y());
        float z = interp.apply(progress, this.z(), pos.z());
        return this.set(x, y, z);
    }

    public Vec3 rotate(float degX, float degY, float degZ) {
        float radiansX = (float)Math.toRadians(degX);
        float radiansY = (float)Math.toRadians(degY);
        float radiansZ = (float)Math.toRadians(degZ);
        float cosX = (float)Math.cos(radiansX);
        float sinX = (float)Math.sin(radiansX);
        float cosY = (float)Math.cos(radiansY);
        float sinY = (float)Math.sin(radiansY);
        float cosZ = (float)Math.cos(radiansZ);
        float sinZ = (float)Math.sin(radiansZ);
        float x = this.x();
        float y = this.y();
        float z = this.z();
        float tempY = y * cosX - z * sinX;
        float tempZ = y * sinX + z * cosX;
        float tempX = x * cosY + tempZ * sinY;
        tempZ = -x * sinY + tempZ * cosY;
        this.set(tempX * cosZ - tempY * sinZ, tempX * sinZ + tempY * cosZ, tempZ);
        return this;
    }

    public Vec3 angle() {
        Vec3 normalized = this.cpy().nor();
        float yaw = (float)Math.atan2(normalized.z(), normalized.x());
        float pitch = (float)Math.asin(normalized.y());
        return this.set(pitch, yaw, 0.0f);
    }

    public Vec3 angleBetween(Pos3 other) {
        return other.cpypos().vec().sub(this).angle().rotationFix();
    }

    public float cross(Pos3 other) {
        return this.x() * other.y() - this.y() * other.x();
    }

    public Vec3 rotationFix() {
        if (this.x() > 180.0f) {
            this.x(this.x() - 360.0f);
        }
        if (this.y() > 180.0f) {
            this.y(this.y() - 360.0f);
        }
        if (this.z() > 180.0f) {
            this.z(this.z() - 360.0f);
        }
        return this;
    }

    public float dst(Pos3 b) {
        return this.cpy().sub(b).len();
    }

    public float dst2(Pos3 b) {
        return this.cpy().sub(b).len2();
    }

    public boolean posEquals(Pos3 b) {
        return b.x() == this.x() && b.y() == this.y() && b.z() == this.z();
    }

    public void constrain(Vec3 target, float targetDist, boolean less, boolean greater) {
        Vec3 delta = target.cpy().sub(this);
        float dst = delta.len();
        if (less && dst < targetDist) {
            return;
        }
        if (greater && dst > targetDist) {
            return;
        }
        if (dst == 0.0f) {
            this.add(targetDist, 0.0f, 0.0f);
            return;
        }
        float scale = targetDist / dst;
        float newX = target.x() + delta.x() * scale;
        float newY = target.y() + delta.y() * scale;
        float newZ = target.z() + delta.z() * scale;
        this.set(newX, newY, newZ);
    }

    public void constrain2(Vec3 b, float targetDist, boolean less, boolean greater) {
        Vec3 delta = b.cpy().sub(this);
        float dst = delta.len();
        if (less && dst < targetDist) {
            return;
        }
        if (greater && dst > targetDist) {
            return;
        }
        if (dst == 0.0f) {
            return;
        }
        float diff = (dst - targetDist) / dst / 2.0f;
        float offsetX = delta.x() * diff;
        float offsetY = delta.y() * diff;
        float offsetZ = delta.z() * diff;
        this.add(offsetX, offsetY, offsetZ);
        b.sub(offsetX, offsetY, offsetZ);
    }
}

