/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.phys;

import com.mojang.blaze3d.vertex.PoseStack;
import org.joml.Matrix4f;
import pro.komaru.tridot.util.comps.phys.Rectc;

public class AbsRect
implements Rectc {
    public float x;
    public float y;
    public float x2;
    public float y2;
    public static AbsRect ZERO = new AbsRect();

    public AbsRect() {
    }

    public AbsRect(float x, float y, float x2, float y2) {
        this.set(x, y, x2, y2);
    }

    public AbsRect set(float x, float y, float x2, float y2) {
        this.x = x;
        this.y = y;
        this.x2 = x2;
        this.y2 = y2;
        return this;
    }

    @Override
    public float x() {
        return (this.x + this.x2) / 2.0f;
    }

    @Override
    public AbsRect x(float value) {
        float w = this.w();
        this.x = value - w / 2.0f;
        this.x2 = value + w / 2.0f;
        return this;
    }

    @Override
    public float y() {
        return (this.y + this.y2) / 2.0f;
    }

    @Override
    public AbsRect y(float value) {
        float h = this.h();
        this.y = value - h / 2.0f;
        this.y2 = value + h / 2.0f;
        return this;
    }

    @Override
    public float w() {
        return Math.abs(this.x2 - this.x);
    }

    @Override
    public float h() {
        return Math.abs(this.y2 - this.y);
    }

    @Override
    public AbsRect w(float w) {
        float c = this.x();
        this.x = c - w / 2.0f;
        this.x2 = c + w / 2.0f;
        return this;
    }

    @Override
    public AbsRect h(float h) {
        float c = this.y();
        this.y = c - h / 2.0f;
        this.y2 = c + h / 2.0f;
        return this;
    }

    public AbsRect apply(float trx, float try_, float sclx, float scly) {
        return (AbsRect)this.xywh(trx + this.x * sclx, try_ + this.y * scly, this.w() * sclx, this.h() * scly);
    }

    public AbsRect mat(Matrix4f mat) {
        float scaleX = (float)Math.sqrt(mat.m00() * mat.m00() + mat.m01() * mat.m01() + mat.m02() * mat.m02());
        float scaleY = (float)Math.sqrt(mat.m10() * mat.m10() + mat.m11() * mat.m11() + mat.m12() * mat.m12());
        float translateX = mat.m30();
        float translateY = mat.m31();
        return this.apply(translateX, translateY, scaleX, scaleY);
    }

    public AbsRect pose(PoseStack pose) {
        return this.mat(pose.m_85850_().m_252922_());
    }

    public static AbsRect xywhDef(float x, float y, float w, float h) {
        AbsRect abs = new AbsRect();
        abs.x = x;
        abs.y = y;
        abs.x2 = x + w;
        abs.y2 = y + h;
        return abs;
    }

    public static AbsRect xywhCent(float x, float y, float w, float h) {
        return (AbsRect)new AbsRect().xywh(x, y, w, h);
    }
}

