/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.math.sort;

import java.util.Comparator;
import pro.komaru.tridot.util.math.sort.ComparableTimSort;
import pro.komaru.tridot.util.math.sort.TimSort;
import pro.komaru.tridot.util.struct.data.Seq;

public class Sort {
    private static ThreadLocal<Sort> instance = ThreadLocal.withInitial(Sort::new);
    private TimSort timSort;
    private ComparableTimSort comparableTimSort;

    public static Sort instance() {
        return instance.get();
    }

    public <T> void sort(Seq<T> a) {
        if (this.comparableTimSort == null) {
            this.comparableTimSort = new ComparableTimSort();
        }
        this.comparableTimSort.doSort(a.items, 0, a.size);
    }

    public <T> void sort(T[] a) {
        if (this.comparableTimSort == null) {
            this.comparableTimSort = new ComparableTimSort();
        }
        this.comparableTimSort.doSort(a, 0, a.length);
    }

    public <T> void sort(T[] a, int fromIndex, int toIndex) {
        if (this.comparableTimSort == null) {
            this.comparableTimSort = new ComparableTimSort();
        }
        this.comparableTimSort.doSort(a, fromIndex, toIndex);
    }

    public <T> void sort(Seq<T> a, Comparator<? super T> c) {
        if (this.timSort == null) {
            this.timSort = new TimSort();
        }
        this.timSort.doSort(a.items, c, 0, a.size);
    }

    public <T> void sort(T[] a, Comparator<? super T> c) {
        if (this.timSort == null) {
            this.timSort = new TimSort();
        }
        this.timSort.doSort(a, c, 0, a.length);
    }

    public <T> void sort(T[] a, Comparator<? super T> c, int fromIndex, int toIndex) {
        if (this.timSort == null) {
            this.timSort = new TimSort();
        }
        this.timSort.doSort(a, c, fromIndex, toIndex);
    }
}

