/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.comps.phys;

import pro.komaru.tridot.util.comps.phys.X;
import pro.komaru.tridot.util.comps.phys.Y;
import pro.komaru.tridot.util.phys.AbsRect;
import pro.komaru.tridot.util.phys.CenteredRect;
import pro.komaru.tridot.util.phys.Vec2;

public interface Rectc
extends X,
Y {
    @Override
    public Rectc x(float var1);

    @Override
    public Rectc y(float var1);

    public float w();

    public float h();

    public Rectc w(float var1);

    public Rectc h(float var1);

    public static Rectc init(final float x, final float y, final float w, final float h) {
        return new Rectc(){
            float xo;
            float yo;
            float wo;
            float ho;
            {
                this.xo = x;
                this.yo = y;
                this.wo = w;
                this.ho = h;
            }

            @Override
            public Rectc x(float value) {
                this.xo = value;
                return this;
            }

            @Override
            public Rectc y(float value) {
                this.yo = value;
                return this;
            }

            @Override
            public float w() {
                return this.wo;
            }

            @Override
            public float h() {
                return this.ho;
            }

            @Override
            public Rectc w(float w2) {
                this.wo = w2;
                return this;
            }

            @Override
            public Rectc h(float h2) {
                this.ho = h2;
                return this;
            }

            @Override
            public float x() {
                return this.xo;
            }

            @Override
            public float y() {
                return this.yo;
            }
        };
    }

    default public Rectc xywh(float x, float y, float w, float h) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    default public Rectc xywhTopLeft(float x, float y, float w, float h) {
        return this.xywh(x + w / 2.0f, y + h / 2.0f, w, h);
    }

    default public Rectc translate(float x, float y) {
        this.x(this.x() + x);
        this.y(this.y() + y);
        return this;
    }

    default public <XY extends X & Y> Rectc scale(XY whscl) {
        return this.scale(whscl, whscl);
    }

    default public Rectc scale(X wscl, Y hscl) {
        return this.scale(wscl.x(), hscl.y());
    }

    default public Rectc scale(float wscl, float hscl) {
        this.w(this.w() * wscl);
        this.h(this.h() * hscl);
        return this;
    }

    default public boolean collides(Rectc rect) {
        Vec2 tl1 = this.topLeft();
        Vec2 tr1 = this.topRight();
        Vec2 bl1 = this.botLeft();
        Vec2 br1 = this.botRight();
        Vec2 tl2 = rect.topLeft();
        Vec2 tr2 = rect.topRight();
        Vec2 bl2 = rect.botLeft();
        Vec2 br2 = rect.botRight();
        return tr1.x() > tl2.x() && tl1.x() < tr2.x() && br1.y() > tl2.y() && bl1.y() < tr2.y();
    }

    default public <XY extends X & Y> boolean inside(XY xy) {
        return this.inside(xy, xy);
    }

    default public boolean inside(X x, Y y) {
        return this.inside(x.x(), y.y());
    }

    default public boolean inside(float x, float y) {
        float otherX = x - this.x();
        float otherY = y - this.y();
        return -this.w() / 2.0f <= otherX && otherY <= this.w() / 2.0f && -this.h() / 2.0f <= otherY && otherY <= this.h() / 2.0f;
    }

    default public Vec2 topLeft() {
        return new Vec2(this.x(), this.y()).add(-this.w() / 2.0f, -this.h() / 2.0f);
    }

    default public Vec2 topRight() {
        return new Vec2(this.x(), this.y()).add(this.w() / 2.0f, -this.h() / 2.0f);
    }

    default public Vec2 botLeft() {
        return new Vec2(this.x(), this.y()).add(-this.w() / 2.0f, this.h() / 2.0f);
    }

    default public Vec2 botRight() {
        return new Vec2(this.x(), this.y()).add(this.w() / 2.0f, this.h() / 2.0f);
    }

    default public CenteredRect centered() {
        return new CenteredRect(this.x(), this.y(), this.w(), this.h());
    }

    default public AbsRect absolute() {
        return AbsRect.xywhCent(this.x(), this.y(), this.w(), this.h());
    }
}

