/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.types;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractTridotArrow;

public class ConfigurableBowItem
extends BowItem {
    public double baseDamage;
    public int arrowBaseDamage;
    public float time = 20.0f;
    public Supplier<? extends EntityType<? extends AbstractArrow>> arrow;

    public ConfigurableBowItem(double pBaseDamage, Item.Properties pProperties) {
        super(pProperties);
        this.baseDamage = pBaseDamage;
        this.arrowBaseDamage = 2;
        this.arrow = () -> EntityType.f_20548_;
    }

    public ConfigurableBowItem(double pBaseDamage, float pTime, Item.Properties pProperties) {
        this(pBaseDamage, pProperties);
        this.time = pTime;
    }

    public ConfigurableBowItem(Supplier<? extends EntityType<? extends AbstractArrow>> arrow, double pBaseDamage, int pArrowBaseDamage, Item.Properties pProperties) {
        super(pProperties);
        this.baseDamage = pBaseDamage;
        this.arrowBaseDamage = pArrowBaseDamage;
        this.arrow = arrow;
    }

    public ConfigurableBowItem(Supplier<? extends EntityType<? extends AbstractArrow>> arrow, double pBaseDamage, int pArrowBaseDamage, float pTime, Item.Properties pProperties) {
        super(pProperties);
        this.baseDamage = pBaseDamage;
        this.arrowBaseDamage = pArrowBaseDamage;
        this.arrow = arrow;
        this.time = pTime;
    }

    @NotNull
    public EntityType<? extends AbstractArrow> getDefaultType() {
        return this.arrow.get();
    }

    public static float getPowerForTime(int pCharge, float time) {
        float f = (float)pCharge / time;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void doPreSpawn(AbstractArrow abstractarrow, Player player, ItemStack itemstack, float power, boolean infiniteArrows) {
        abstractarrow = this.customArrow(abstractarrow);
        abstractarrow.m_36781_(abstractarrow.m_36789_() + this.baseDamage);
        abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.0f, 1.0f);
        if (power == 1.0f) {
            abstractarrow.m_36762_(true);
        }
        if (infiniteArrows || player.m_150110_().f_35937_ && (itemstack.m_150930_(Items.f_42737_) || itemstack.m_150930_(Items.f_42738_))) {
            abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }

    public AbstractArrow createArrow(Level pLevel, Player player) {
        AbstractArrow customArrow = (AbstractArrow)this.arrow.get().m_20615_(pLevel);
        customArrow.m_20219_(new Vec3(player.m_146892_().f_82479_, player.m_146892_().f_82480_ - (double)0.1f, player.m_146892_().f_82481_));
        customArrow.m_5602_((Entity)player);
        if (customArrow instanceof AbstractTridotArrow) {
            AbstractTridotArrow valor = (AbstractTridotArrow)customArrow;
            valor.doPostSpawn();
        }
        return customArrow;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            boolean flag = player.m_150110_().f_35937_ || EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)pStack) > 0;
            ItemStack itemstack = player.m_6298_(pStack);
            int i = this.m_8105_(pStack) - pTimeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)i, (!itemstack.m_41619_() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || flag) {
                float power;
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if (!((double)(power = ConfigurableBowItem.getPowerForTime(i, this.time)) < 0.1)) {
                    boolean infiniteArrows;
                    boolean bl = infiniteArrows = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, pStack, player);
                    if (!pLevel.m_5776_()) {
                        int enchantmentPunch;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                        AbstractArrow abstractarrow = arrowitem == Items.f_42412_ && this.arrow.get() != EntityType.f_20548_ ? this.createArrow(pLevel, player) : arrowitem.m_6394_(pLevel, itemstack, (LivingEntity)player);
                        abstractarrow.m_5602_((Entity)player);
                        this.doPreSpawn(abstractarrow, player, itemstack, power, infiniteArrows);
                        int enchantmentPower = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44988_, (ItemStack)pStack);
                        if (enchantmentPower > 0) {
                            abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)enchantmentPower * 0.5 + 0.5);
                        }
                        if ((enchantmentPunch = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44989_, (ItemStack)pStack)) > 0) {
                            abstractarrow.m_36735_(enchantmentPunch);
                        }
                        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44990_, (ItemStack)pStack) > 0) {
                            abstractarrow.m_20254_(100);
                        }
                        pStack.m_41622_(1, (LivingEntity)player, p_289501_ -> p_289501_.m_21190_(player.m_7655_()));
                        pLevel.m_7967_((Entity)abstractarrow);
                    }
                    pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 1.2f) + power * 0.5f);
                    if (!infiniteArrows && !player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            player.m_150109_().m_36057_(itemstack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    private double calculateAverageDamage(ItemStack pStack) {
        double baseArrowDamage = this.baseDamage + 2.0;
        int powerLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44988_, (ItemStack)pStack);
        double powerBonus = powerLevel > 0 ? (double)powerLevel * 0.5 + 0.5 : 0.0;
        return (baseArrowDamage + powerBonus) * 4.0 - 2.0;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        Utils.Items.addSkinTooltip(pStack, pTooltipComponents);
        double damage = this.calculateAverageDamage(pStack);
        if (this.arrow.get() != EntityType.f_20548_) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tridot.special_arrow").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)this.getDefaultType().m_20676_().getString()).m_130938_(pStack.m_41791_().getStyleModifier())));
        }
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.tridot.bow_damage", (Object[])new Object[]{Math.floor(damage)}).m_130940_(ChatFormatting.GRAY));
    }
}

