/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.components.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class TextClientComponent
implements ClientTooltipComponent {
    private final int maxChars = 200;
    private final List<FormattedCharSequence> lines;
    private final int paddingTop;

    private TextClientComponent(MutableComponent text, int paddingTop) {
        this.lines = Language.m_128107_().m_128112_(Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)text, 200, text.m_7383_()));
        this.paddingTop = paddingTop;
    }

    public static ClientTooltipComponent create(MutableComponent text) {
        return new TextClientComponent(text, 0);
    }

    public int m_142103_() {
        return Math.max(0, 12 * this.lines.size() + this.paddingTop);
    }

    public int m_142069_(Font pFont) {
        int width = 0;
        for (FormattedCharSequence line : this.lines) {
            float scale = 1.0f;
            int lineWidth = (int)((float)pFont.m_92724_(line) * scale);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    public void m_142440_(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
        int y = pMouseY + this.paddingTop;
        for (FormattedCharSequence line : this.lines) {
            float scale = 1.0f;
            Matrix4f scaled = new Matrix4f((Matrix4fc)pMatrix);
            scaled.scale(scale, scale, 1.0f);
            pFont.m_272191_(line, (float)pMouseX / scale, (float)y / scale + 1.0f, -1, true, scaled, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            y += 9;
        }
    }
}

