/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.api.interfaces.Allied;
import pro.komaru.tridot.api.interfaces.BossEntity;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;

public abstract class AbstractBoss
extends MultiAttackMob
implements Enemy,
BossEntity,
Allied {
    public final List<UUID> nearbyPlayers = new ArrayList<UUID>();
    public final Map<UUID, Float> damageMap = new HashMap<UUID, Float>();

    public AbstractBoss(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_5801_() {
        return false;
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || pEntity instanceof Allied;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return super.m_6779_(pTarget) && !this.m_7307_((Entity)pTarget);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readBossData(pCompound);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.saveBossData(pCompound);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Allied) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            UUID playerUUID = player.m_20148_();
            this.getDamageMap().put(playerUUID, Float.valueOf(this.getDamageMap().getOrDefault(playerUUID, Float.valueOf(0.0f)).floatValue() + amount));
        }
        return super.m_6469_(source, amount);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.getNearbyPlayers().clear();
        this.initializeNearbyPlayers(this.m_9236_(), (Entity)this);
        this.applyBonusHealth((Mob)this);
    }

    @Override
    public List<UUID> getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public Map<UUID, Float> getDamageMap() {
        return this.damageMap;
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41619_() || this.m_9236_().f_46443_) {
            return null;
        }
        this.initializeLoot(this.m_9236_(), stack, this.m_20097_().m_7494_(), offsetY);
        return null;
    }
}

