/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry;

import java.util.function.Supplier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.api.interfaces.CooldownReductionItem;
import pro.komaru.tridot.api.interfaces.DashItem;
import pro.komaru.tridot.api.interfaces.RadiusItem;
import pro.komaru.tridot.common.registry.enchantments.DashEnchantment;
import pro.komaru.tridot.common.registry.enchantments.OverdriveEnchantment;
import pro.komaru.tridot.common.registry.enchantments.RadiusEnchantment;

public class EnchantmentsRegistry {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"tridot");
    public static final EnchantmentCategory DASH_WEAPON = EnchantmentCategory.create((String)"radius_weapon", item -> item instanceof DashItem);
    public static final EnchantmentCategory RADIUS_WEAPON = EnchantmentCategory.create((String)"radius_weapon", item -> item instanceof RadiusItem);
    public static final EnchantmentCategory OVERDRIVE_CATEGORY = EnchantmentCategory.create((String)"overdrive", item -> item instanceof CooldownReductionItem);
    public static final RegistryObject<Enchantment> DASH = EnchantmentsRegistry.registerEnchantment("dash", DashEnchantment::new);
    public static final RegistryObject<Enchantment> RADIUS = EnchantmentsRegistry.registerEnchantment("radius", RadiusEnchantment::new);
    public static final RegistryObject<Enchantment> OVERDRIVE = EnchantmentsRegistry.registerEnchantment("overdrive", OverdriveEnchantment::new);

    private static RegistryObject<Enchantment> registerEnchantment(String id, Supplier<Enchantment> enchantment) {
        return ENCHANTMENTS.register(id, enchantment);
    }

    public static void register(IEventBus eventBus) {
        ENCHANTMENTS.register(eventBus);
    }
}

