/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.render.screenshake;

import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.Tridot;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.common.config.ClientConfig;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.math.Mathf;
import pro.komaru.tridot.util.math.raycast.RayCast;
import pro.komaru.tridot.util.math.raycast.RayCastContext;
import pro.komaru.tridot.util.math.raycast.RayHitResult;
import pro.komaru.tridot.util.phys.Vec3;

public class ScreenshakeHandler {
    public static final ArrayList<ScreenshakeInstance> INSTANCES = new ArrayList();
    public static float intensityRotation;
    public static float intensityPosition;
    public static float intensityFov;
    public static float intensityFovNormalize;
    public static Vec3 intensityVector;
    public static Vec3 intensityVectorOld;
    public static ArcRandom rand;

    public static void cameraTick(Camera camera) {
        Vec3 pos;
        if (intensityRotation > 0.0f) {
            float yawOffset = ScreenshakeHandler.randomizeOffset(intensityRotation);
            float pitchOffset = ScreenshakeHandler.randomizeOffset(intensityRotation);
            camera.m_90572_(camera.m_90590_() + yawOffset, camera.m_90589_() + pitchOffset);
        }
        boolean cameraUpdate = false;
        Vec3 cameraPos = pos = Vec3.from(camera.m_90583_());
        if (intensityPosition > 0.0f) {
            pos = ScreenshakeHandler.intensityPosVec(pos).cpy();
            cameraUpdate = true;
        }
        if (!intensityVector.equals(Vec3.zero()) && !intensityVectorOld.equals(Vec3.zero())) {
            pos = ScreenshakeHandler.intensityVec(pos).cpy();
            cameraUpdate = true;
        }
        if (cameraUpdate) {
            Level level = Tridot.PROXY.getLevel();
            if (level != null) {
                RayHitResult hitResult = RayCast.getHit(level, new RayCastContext(cameraPos, pos).setBlockShape(RayCastContext.Block.VISUAL));
                double distance = Math.max(0.0f, cameraPos.cpy().sub(hitResult.getPos()).len() - 0.1f);
                float dX = cameraPos.x() - hitResult.getPos().x();
                float dY = cameraPos.y() - hitResult.getPos().y();
                float dZ = cameraPos.z() - hitResult.getPos().z();
                float pitch = (float)(Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI);
                float x = (float)(Math.sin(pitch) * Math.cos(Math.atan2(dZ, dX)) * distance);
                float y = (float)(Math.cos(pitch) * distance);
                float z = (float)(Math.sin(pitch) * Math.sin(Math.atan2(dZ, dX)) * distance);
                pos = cameraPos.cpy().add(x, y, z);
            }
            camera.m_90584_((double)pos.x(), (double)pos.y(), (double)pos.z());
        }
    }

    @NotNull
    private static Vec3 intensityVec(Pos3 pos) {
        return pos.cpypos().vec().add(intensityVectorOld.cpy().lerp(intensityVector, ClientTick.partialTicks)).vec();
    }

    @NotNull
    private static Vec3 intensityPosVec(Pos3 pos) {
        float angleA = rand.nextFloat() * Mathf.pi * 2.0f;
        float angleB = rand.nextFloat() * Mathf.pi * 2.0f;
        float x = (float)(Math.cos(angleA) * Math.cos(angleB)) * ScreenshakeHandler.randomizeOffset(intensityPosition);
        float y = (float)(Math.sin(angleA) * Math.cos(angleB)) * ScreenshakeHandler.randomizeOffset(intensityPosition);
        float z = (float)Math.sin(angleB) * ScreenshakeHandler.randomizeOffset(intensityPosition);
        return pos.cpypos().vec().add(x, y, z).vec();
    }

    public static void fovTick(ComputeFovModifierEvent event) {
        float fovModifier = event.getFovModifier();
        if (fovModifier != event.getNewFovModifier()) {
            fovModifier = event.getNewFovModifier();
        }
        boolean update = false;
        if (intensityFov >= 0.0f) {
            float offset = ScreenshakeHandler.randomizeOffset(intensityFov);
            fovModifier += offset;
            update = true;
        }
        if (intensityFovNormalize != 0.0f) {
            fovModifier += intensityFovNormalize;
            update = true;
        }
        if (update) {
            event.setNewFovModifier((float)Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)fovModifier));
        }
    }

    public static float apply(ScreenshakeInstance instance, float current, float update) {
        if (instance.isNormalize) {
            return current + update;
        }
        return update;
    }

    public static void clientTick(Camera camera) {
        float intensity = (float)((Double)ClientConfig.SCREENSHAKE_INTENSITY.get()).doubleValue();
        float rotationNormalize = 0.0f;
        float positionNormalize = 0.0f;
        float fovNormalize = 0.0f;
        float fovNorm = 0.0f;
        float rotation = 0.0f;
        float position = 0.0f;
        float fov = 0.0f;
        Vec3 vector = Vec3.zero();
        for (ScreenshakeInstance instance : INSTANCES) {
            float update = instance.updateIntensity(camera);
            if (instance.isRotation) {
                rotation = ScreenshakeHandler.apply(instance, rotationNormalize, update);
            }
            if (instance.isPosition) {
                position = ScreenshakeHandler.apply(instance, positionNormalize, update);
            }
            if (instance.isFov) {
                if (instance.isNormalize) {
                    fovNormalize += update;
                } else if (instance.isFovNormalize) {
                    fovNorm += update;
                } else {
                    fov += update;
                }
            }
            if (!instance.isVector) continue;
            Vec3 scaledVector = instance.vector.scale(update * intensity);
            if (instance.isNormalize) {
                vector = vector.add(scaledVector.sub(vector));
                continue;
            }
            vector = vector.add(scaledVector);
        }
        rotationNormalize = Math.min(rotationNormalize, intensity);
        positionNormalize = Math.min(positionNormalize, intensity);
        fovNorm = Math.min(fovNorm, intensity);
        intensityRotation = (float)Math.max(Math.pow(rotationNormalize, 3.0), (double)(rotation *= intensity));
        intensityPosition = (float)Math.max(Math.pow(positionNormalize / 2.0f, 3.0), (double)(position *= intensity));
        intensityFov = Math.max(fovNorm, fov *= intensity);
        intensityFovNormalize = fovNormalize;
        intensityVectorOld = intensityVector;
        intensityVector = vector;
        INSTANCES.removeIf(i -> i.progress >= i.duration);
    }

    public static void add(ScreenshakeInstance instance) {
        INSTANCES.add(instance);
    }

    public static float randomizeOffset(float offset) {
        if (offset == 0.0f) {
            return 0.0f;
        }
        return rand.nextFloat(-offset * 2.0f, offset * 2.0f);
    }

    static {
        intensityVector = Vec3.zero();
        intensityVectorOld = Vec3.zero();
        rand = Tmp.rnd;
    }
}

