/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.text;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.util.Col;

public class DotTextParser {
    public static List<Component> parse(String input, int wrapWidth, Font font) {
        ArrayList<Component> lines = new ArrayList<Component>();
        Style currentStyle = Style.f_131099_;
        StringBuilder word = new StringBuilder();
        MutableComponent line = Component.m_237119_();
        int width = 0;
        for (int i = 0; i <= input.length(); ++i) {
            char chr;
            char c = chr = i < input.length() ? (char)input.charAt(i) : (char)'\n';
            if (chr == ' ' || chr == '\n') {
                if (!word.isEmpty()) {
                    MutableComponent wordComponent = Component.m_237113_((String)word.toString()).m_130948_(currentStyle);
                    int wordWidth = font.m_92852_((FormattedText)wordComponent);
                    if (width + wordWidth > wrapWidth) {
                        lines.add((Component)line);
                        line = Component.m_237119_();
                        width = 0;
                    }
                    line.m_7220_((Component)wordComponent).m_130946_(" ");
                    width += wordWidth + font.m_92895_(" ");
                    word.setLength(0);
                }
                if (chr != 10) continue;
                lines.add((Component)line);
                line = Component.m_237119_();
                width = 0;
                continue;
            }
            if (chr == '&' && i + 1 < input.length()) {
                char code = input.charAt(++i);
                currentStyle = switch (code) {
                    case 'i' -> currentStyle.m_131155_(Boolean.valueOf(true));
                    case 'b' -> currentStyle.m_131136_(Boolean.valueOf(true));
                    case 's' -> currentStyle.m_178522_(Boolean.valueOf(true));
                    case 'u' -> currentStyle.m_131162_(Boolean.valueOf(true));
                    case 'k' -> currentStyle.m_178524_(Boolean.valueOf(true));
                    default -> {
                        word.append('&').append(code);
                        yield currentStyle;
                    }
                };
                continue;
            }
            if (chr == '/' && i + 1 < input.length() && input.charAt(i + 1) == '&') {
                currentStyle = Style.f_131099_;
                ++i;
                continue;
            }
            if (chr == '#' && i + 7 <= input.length()) {
                String hex = input.substring(i + 1, i + 7);
                currentStyle = DotStyle.of().color(Col.fromHex(hex));
                i += 6;
                continue;
            }
            word.append(chr);
        }
        if (!line.getString().isEmpty()) {
            lines.add((Component)line);
        }
        return lines;
    }
}

