/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle.data;

import net.minecraft.client.particle.SpriteSet;
import pro.komaru.tridot.client.gfx.particle.screen.GenericScreenParticle;

public class ScreenSpriteParticleData {
    public static final ScreenSpriteParticleData RANDOM = new Random();
    public static final ScreenSpriteParticleData FIRST = new First();
    public static final ScreenSpriteParticleData LAST = new Last();
    public static final ScreenSpriteParticleData WITH_AGE = new WithAge();
    public static final ScreenSpriteParticleData CRUMBS_RANDOM = new CrumbsRandom(3.0f, 1.0f);
    public static final ScreenSpriteParticleData CRUMBS_FIRST = new CrumbsFirst(3.0f, 1.0f);
    public static final ScreenSpriteParticleData CRUMBS_LAST = new CrumbsLast(3.0f, 1.0f);
    public static final ScreenSpriteParticleData CRUMBS_WITH_AGE = new CrumbsWithAge(3.0f, 1.0f);
    public static final ScreenSpriteParticleData CRUMBS_LARGE_RANDOM = new CrumbsRandom(1.0f, 1.0f);
    public static final ScreenSpriteParticleData CRUMBS_LARGE_FIRST = new CrumbsFirst(1.0f, 1.0f);
    public static final ScreenSpriteParticleData CRUMBS_LARGE_LAST = new CrumbsLast(1.0f, 1.0f);
    public static final ScreenSpriteParticleData CRUMBS_LARGE_WITH_AGE = new CrumbsWithAge(1.0f, 1.0f);

    public void init(GenericScreenParticle particle) {
    }

    public void tick(GenericScreenParticle particle) {
    }

    public void renderTick(GenericScreenParticle particle, float partialTicks) {
    }

    public float getU0(GenericScreenParticle particle) {
        return particle.sprite.m_118409_();
    }

    public float getU1(GenericScreenParticle particle) {
        return particle.sprite.m_118410_();
    }

    public float getV0(GenericScreenParticle particle) {
        return particle.sprite.m_118411_();
    }

    public float getV1(GenericScreenParticle particle) {
        return particle.sprite.m_118412_();
    }

    public static class Random
    extends ScreenSpriteParticleData {
        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite((SpriteSet)particle.spriteSet);
            }
        }
    }

    public static class First
    extends ScreenSpriteParticleData {
        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }
    }

    public static class Last
    extends ScreenSpriteParticleData {
        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.spriteSet.f_107406_.size() - 1);
            }
        }
    }

    public static class WithAge
    extends ScreenSpriteParticleData {
        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }

        @Override
        public void tick(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.age * particle.spriteSet.f_107406_.size() / particle.lifetime);
            }
        }
    }

    public static class CrumbsRandom
    extends Crumbs {
        public CrumbsRandom(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite((SpriteSet)particle.spriteSet);
            }
        }
    }

    public static class CrumbsFirst
    extends Crumbs {
        public CrumbsFirst(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }
    }

    public static class CrumbsLast
    extends Crumbs {
        public CrumbsLast(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.spriteSet.f_107406_.size() - 1);
            }
        }
    }

    public static class CrumbsWithAge
    extends Crumbs {
        public CrumbsWithAge(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }

        @Override
        public void tick(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.age * particle.spriteSet.f_107406_.size() / particle.lifetime);
            }
        }
    }

    public static class CrumbsValue
    extends Crumbs {
        public int value;

        public CrumbsValue(int value, float offset, float size) {
            super(offset, size);
            this.value = value;
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null && this.value >= 0 && this.value < particle.spriteSet.f_107406_.size()) {
                particle.pickSprite(this.value);
            }
        }
    }

    public static class Crumbs
    extends ScreenSpriteParticleData {
        public float offset;
        public float size;

        public Crumbs(float offset, float size) {
            this.offset = offset;
            this.size = size;
        }

        @Override
        public float getU0(GenericScreenParticle particle) {
            return particle.sprite.m_118409_() + (particle.sprite.m_118410_() - particle.sprite.m_118409_()) * ((particle.uo * this.offset + this.size) / (this.offset + this.size));
        }

        @Override
        public float getU1(GenericScreenParticle particle) {
            return particle.sprite.m_118409_() + (particle.sprite.m_118410_() - particle.sprite.m_118409_()) * (particle.uo * this.offset / (this.offset + this.size));
        }

        @Override
        public float getV0(GenericScreenParticle particle) {
            return particle.sprite.m_118411_() + (particle.sprite.m_118412_() - particle.sprite.m_118411_()) * (particle.vo * this.offset / (this.offset + this.size));
        }

        @Override
        public float getV1(GenericScreenParticle particle) {
            return particle.sprite.m_118411_() + (particle.sprite.m_118412_() - particle.sprite.m_118411_()) * ((particle.vo * this.offset + this.size) / (this.offset + this.size));
        }
    }

    public static class Value
    extends ScreenSpriteParticleData {
        public int value;

        public Value(int value) {
            this.value = value;
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null && this.value >= 0 && this.value < particle.spriteSet.f_107406_.size()) {
                particle.pickSprite(this.value);
            }
        }
    }
}

