/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle.behavior;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.behavior.ICustomBehaviorParticleRender;
import pro.komaru.tridot.client.gfx.particle.behavior.ParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.behavior.TrailParticleBehaviorBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.component.ParticleBehaviorComponent;
import pro.komaru.tridot.client.gfx.particle.behavior.component.TrailParticleBehaviorComponent;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.gfx.trail.TrailPoint;
import pro.komaru.tridot.client.gfx.trail.TrailPointBuilder;
import pro.komaru.tridot.client.render.RenderBuilder;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.phys.Vec3;

public class TrailParticleBehavior
extends ParticleBehavior
implements ICustomBehaviorParticleRender {
    public ColorParticleData colorData;
    public GenericParticleData transparencyData;
    public boolean secondColor;
    public int trailSize;
    Function<Float, Float> widthFunc;

    public TrailParticleBehavior(ColorParticleData colorData, GenericParticleData transparencyData, boolean secondColor, int trailSize, Function<Float, Float> widthFunc, SpinParticleData xSpinData, SpinParticleData ySpinData, SpinParticleData zSpinData, float xOffset, float yOffset, float zOffset, boolean firstSide, boolean secondSide, boolean camera, boolean xRotCam, boolean yRotCam) {
        super(xSpinData, ySpinData, zSpinData, xOffset, yOffset, zOffset, firstSide, secondSide, camera, xRotCam, yRotCam);
        this.colorData = colorData;
        this.transparencyData = transparencyData;
        this.secondColor = secondColor;
        this.trailSize = trailSize;
        this.widthFunc = widthFunc;
    }

    @Override
    public TrailParticleBehavior copy() {
        return new TrailParticleBehavior(this.colorData, this.transparencyData, this.secondColor, this.trailSize, this.widthFunc, this.xSpinData, this.ySpinData, this.zSpinData, this.xOffset, this.yOffset, this.zOffset, this.firstSide, this.secondSide, this.camera, this.xRotCam, this.yRotCam);
    }

    public static TrailParticleBehaviorBuilder create() {
        return new TrailParticleBehaviorBuilder(0.0f, 0.0f, 0.0f);
    }

    public static TrailParticleBehaviorBuilder create(float xOffset, float yOffset, float zOffset) {
        return new TrailParticleBehaviorBuilder((float)Math.toRadians(xOffset), (float)Math.toRadians(yOffset), (float)Math.toRadians(zOffset));
    }

    @Override
    public TrailParticleBehaviorComponent getComponent() {
        return new TrailParticleBehaviorComponent();
    }

    public TrailParticleBehaviorComponent getTrailComponent(GenericParticle particle) {
        ParticleBehaviorComponent particleBehaviorComponent = particle.behaviorComponent;
        if (particleBehaviorComponent instanceof TrailParticleBehaviorComponent) {
            TrailParticleBehaviorComponent behaviorComponent = (TrailParticleBehaviorComponent)particleBehaviorComponent;
            return behaviorComponent;
        }
        return this.getComponent();
    }

    @Override
    public void init(GenericParticle particle) {
        super.init(particle);
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        component.trailPointBuilder = TrailPointBuilder.create(this.trailSize);
        float r1 = GenericParticle.pickRandomValue(this.colorData.r1, this.colorData.rr11, this.colorData.rr12);
        float g1 = GenericParticle.pickRandomValue(this.colorData.g1, this.colorData.rg11, this.colorData.rg12);
        float b1 = GenericParticle.pickRandomValue(this.colorData.b1, this.colorData.rb11, this.colorData.rb12);
        float r2 = GenericParticle.pickRandomValue(this.colorData.r2, this.colorData.rr21, this.colorData.rr22);
        float g2 = GenericParticle.pickRandomValue(this.colorData.g2, this.colorData.rg21, this.colorData.rg22);
        float b2 = GenericParticle.pickRandomValue(this.colorData.b2, this.colorData.rb21, this.colorData.rb21);
        component.st = GenericParticle.pickRandomValue(this.transparencyData.startingValue, this.transparencyData.rs1, this.transparencyData.rs2);
        component.mt = GenericParticle.pickRandomValue(this.transparencyData.middleValue, this.transparencyData.rm1, this.transparencyData.rm2);
        component.et = GenericParticle.pickRandomValue(this.transparencyData.endingValue, this.transparencyData.re1, this.transparencyData.re2);
        Tmp.c1.set(r1, g1, b1);
        component.hsv1 = Tmp.c1.toHsv(component.hsv1);
        Tmp.c2.set(r2, g2, b2);
        component.hsv2 = Tmp.c2.toHsv(component.hsv2);
    }

    public void pickColor(GenericParticle particle, float coeff) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        float[] hsv1 = component.hsv1;
        float[] hsv2 = component.hsv2;
        Col col = Col.HSVtoRGB(hsv1[0], hsv1[1] * 100.0f, hsv1[2] * 100.0f);
        Col col2 = Col.HSVtoRGB(hsv2[0], hsv2[1] * 100.0f, hsv2[2] * 100.0f);
        col.lerp(col2, coeff);
        this.setColor(particle, col.r, col.g, col.b);
    }

    public void setColor(GenericParticle particle, float r, float g, float b) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        component.r = r;
        component.g = g;
        component.b = b;
    }

    @Override
    public void updateTraits(GenericParticle particle) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        component.trailPointBuilder.add(Vec3.from(particle.getPosition()));
        component.trailPointBuilder.tick();
        this.pickColor(particle, this.colorData.colorCurveEasing.apply(this.colorData.getProgress(particle.f_107224_, particle.f_107225_)));
        component.a = this.transparencyData.getValue(particle.f_107224_, particle.f_107225_, component.st, component.mt, component.et);
    }

    @Override
    public void updateRenderTraits(GenericParticle particle, float partialTicks) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        this.pickColor(particle, this.colorData.colorCurveEasing.apply(this.colorData.getProgress(particle.f_107224_, particle.f_107225_)));
        component.a = this.transparencyData.getValue(particle.f_107224_, particle.f_107225_, component.st, component.mt, component.et);
    }

    @Override
    public void render(GenericParticle particle, VertexConsumer vertexConsumer, Camera renderInfo, float partialTicks) {
        if (particle.shouldRenderTraits) {
            this.updateRenderTraits(particle, partialTicks);
        }
        TridotParticles.addBehaviorParticleList(particle, this);
    }

    @Override
    public void render(GenericParticle particle, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        ArrayList<TrailPoint> trail = new ArrayList<TrailPoint>(component.trailPointBuilder.points());
        if (trail.size() > 2 && particle.getAge() > component.trailPointBuilder.trailLength.get()) {
            TrailPoint position = (TrailPoint)trail.get(0);
            TrailPoint nextPosition = (TrailPoint)trail.get(1);
            float x = Mth.m_14179_((float)partialTicks, (float)position.getPosition().x, (float)nextPosition.getPosition().x);
            float y = Mth.m_14179_((float)partialTicks, (float)position.getPosition().y, (float)nextPosition.getPosition().y);
            float z = Mth.m_14179_((float)partialTicks, (float)position.getPosition().z, (float)nextPosition.getPosition().z);
            trail.set(0, new TrailPoint(new Vec3(x, y, z)));
        }
        float x = (float)Mth.m_14139_((double)partialTicks, (double)particle.f_107209_, (double)particle.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTicks, (double)particle.f_107210_, (double)particle.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTicks, (double)particle.f_107211_, (double)particle.f_107214_);
        if (!trail.isEmpty()) {
            trail.set(trail.size() - 1, new TrailPoint(new Vec3(x, y, z)));
        }
        RenderBuilder builder = RenderBuilder.create().setRenderType(particle.renderType).setSided(this.firstSide, this.secondSide).setUV(particle.m_5970_(), particle.m_5951_(), particle.m_5952_(), particle.m_5950_()).setColorRaw(particle.getRed(), particle.getGreen(), particle.getBlue()).setAlpha(particle.getAlpha()).setLight(particle.m_6355_(partialTicks));
        if (this.secondColor) {
            builder.setSecondColorRaw(component.r, component.g, component.b).setSecondAlpha(component.a);
        }
        if (this.widthFunc == null) {
            this.widthFunc = f -> f;
        }
        builder.renderTrail(poseStack, trail, f -> Float.valueOf(this.widthFunc.apply((Float)f).floatValue() * (particle.getSize() / 2.0f)));
    }
}

