/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle.behavior;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.behavior.ICustomBehaviorParticleRender;
import pro.komaru.tridot.client.gfx.particle.behavior.ParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.behavior.SphereParticleBehaviorBuilder;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.render.RenderBuilder;

public class SphereParticleBehavior
extends ParticleBehavior
implements ICustomBehaviorParticleRender {
    public int longs;
    public int lats;
    public boolean stretch;

    public SphereParticleBehavior(int longs, int lats, boolean stretch, SpinParticleData xSpinData, SpinParticleData ySpinData, SpinParticleData zSpinData, float xOffset, float yOffset, float zOffset, boolean firstSide, boolean secondSide, boolean camera, boolean xRotCam, boolean yRotCam) {
        super(xSpinData, ySpinData, zSpinData, xOffset, yOffset, zOffset, firstSide, secondSide, camera, xRotCam, yRotCam);
        this.longs = longs;
        this.lats = lats;
        this.stretch = stretch;
    }

    @Override
    public SphereParticleBehavior copy() {
        return new SphereParticleBehavior(this.longs, this.lats, this.stretch, this.xSpinData, this.ySpinData, this.zSpinData, this.xOffset, this.yOffset, this.zOffset, this.firstSide, this.secondSide, this.camera, this.xRotCam, this.yRotCam);
    }

    public static SphereParticleBehaviorBuilder create() {
        return new SphereParticleBehaviorBuilder(0.0f, 0.0f, 0.0f);
    }

    public static SphereParticleBehaviorBuilder create(float xOffset, float yOffset, float zOffset) {
        return new SphereParticleBehaviorBuilder((float)Math.toRadians(xOffset), (float)Math.toRadians(yOffset), (float)Math.toRadians(zOffset));
    }

    @Override
    public void render(GenericParticle particle, VertexConsumer vertexConsumer, Camera renderInfo, float partialTicks) {
        if (particle.shouldRenderTraits) {
            this.updateRenderTraits(particle, partialTicks);
        }
        TridotParticles.addBehaviorParticleList(particle, this);
    }

    @Override
    public void render(GenericParticle particle, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        poseStack.m_85836_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 vec3 = camera.m_90583_();
        Vec3 pos = this.getPosition(particle, Minecraft.m_91087_().f_91063_.m_109153_(), partialTicks);
        poseStack.m_85837_((double)((float)pos.m_7096_()) + vec3.m_7096_(), (double)((float)pos.m_7098_()) + vec3.m_7098_(), (double)((float)pos.m_7094_()) + vec3.m_7094_());
        poseStack.m_252781_(this.getRotate(particle, Minecraft.m_91087_().f_91063_.m_109153_(), partialTicks));
        RenderBuilder.create().setRenderType(particle.renderType).setSided(this.firstSide, this.secondSide).setUV(particle.m_5970_(), particle.m_5951_(), particle.m_5952_(), particle.m_5950_()).setColorRaw(particle.getRed(), particle.getGreen(), particle.getBlue()).setAlpha(particle.getAlpha()).setLight(particle.m_6355_(partialTicks)).renderSphere(poseStack, particle.getSize() / 2.0f, this.longs, this.lats, this.stretch);
        poseStack.m_85849_();
    }
}

